/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.rowmodels;

import com.ca.mat.common.table.FilterableTableRow;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableRow;
import com.ca.mat.rowmodels.CodeViewRowModel;
import com.ca.mat.rowmodels.IXmlAttrHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.Attributes;

public class CallerIdRowModel
extends MATTableRow
implements IXmlAttrHandler,
FilterableTableRow,
Cloneable {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    private static final String sourceClass = CodeViewRowModel.class.getName();
    public static final String TASK_ID = "taskId";
    public static final String CSECT_ID = "csectId";
    public static final String MODULE_ID = "moduleId";
    public static final String MINOR_CAT_ID = "minorCatId";
    public static final String TRAN_ID = "ttran";
    public static final String DBRM_ID = "tdbrm";
    public static final String DBRMNR_ID = "tdbrmnr";
    public static final String OFFSET_ID = "offsetId";
    Logger log = Logger.getLogger(sourceClass);
    Level baseLevel = this.log.getLevel();
    private String outcalid = "";
    private String outccsct = "";
    private String outcoff = "";
    private Integer stmt = null;
    private String function = "";
    private Double active = 0.0;
    private Double wait = 0.0;
    private Double total = 0.0;
    private int count = 0;
    private String taskId = null;
    private String tranId = null;
    private String moduleId = null;
    private String csectId = "";
    private String offsetId = null;
    private String tdbrm = null;
    private String tdbrmnr = null;
    private String minorCatId = null;
    private String locationName;

    public CallerIdRowModel() {
        this(null, "");
    }

    public CallerIdRowModel(MATTableModel dataset, String locationName) {
        super(dataset);
        this.locationName = locationName;
    }

    public CallerIdRowModel(MATTableModel dataset, String locationName, String callerId, String csect, String offset, String statement, String csectDesc) {
        super(dataset);
        this.locationName = locationName;
        this.outcalid = callerId;
        this.outccsct = csect;
        this.outcoff = offset;
        this.function = csectDesc;
    }

    @Override
    protected Object[] getArray() {
        return new Object[]{this.outcalid, this.outccsct, this.outcoff, this.stmt, this.function, this.total, this.active, this.wait, this.count};
    }

    @Override
    public MATTableRow handleAttributes(Attributes attr, MATTableModel dataset, String datasetName) {
        CallerIdRowModel result = new CallerIdRowModel(dataset, datasetName);
        String value = null;
        value = attr.getValue("FUNCTION");
        if (value != null) {
            result.function = value.trim();
        }
        if ((value = attr.getValue("OUTCALID")) != null) {
            result.outcalid = value.trim();
        }
        if ((value = attr.getValue("OUTCCSCT")) != null) {
            result.outccsct = value.trim();
        }
        if ((value = attr.getValue("OUTCOFF")) != null) {
            result.outcoff = value.trim();
        }
        if ((value = attr.getValue("PCT")) != null) {
            result.total = Double.valueOf(value);
        }
        if ((value = attr.getValue("STMT")) != null) {
            result.stmt = Integer.valueOf(value);
        }
        if ((value = attr.getValue("PGICCNT")) != null) {
            result.count = Integer.valueOf(value);
        }
        if ((value = attr.getValue("TTASKID")) != null) {
            result.taskId = value.trim();
        }
        if ((value = attr.getValue("TTRAN")) != null) {
            result.tranId = value.trim();
        }
        if ((value = attr.getValue("CSET")) != null) {
            result.csectId = value.trim();
        }
        if ((value = attr.getValue("MODT")) != null) {
            result.moduleId = value.trim();
        }
        if ((value = attr.getValue("OFFSET")) != null) {
            result.offsetId = value.trim();
        }
        if ((value = attr.getValue("TDBRM")) != null) {
            result.tdbrm = value.trim();
        }
        if ((value = attr.getValue("TDBRMNR")) != null) {
            result.tdbrmnr = value.trim();
        }
        if ((value = attr.getValue("MINCAT")) != null) {
            result.minorCatId = value.trim();
        }
        return result;
    }

    @Override
    public boolean compliesWithFilter(String fieldName, Object value) {
        if (TASK_ID.equals(fieldName)) {
            return this.taskId != null && this.taskId.equals(value);
        }
        if (TRAN_ID.equals(fieldName)) {
            return this.tranId != null && this.tranId.equals(value);
        }
        if (CSECT_ID.equals(fieldName)) {
            return this.csectId != null && this.csectId.equals(value);
        }
        if (MODULE_ID.equals(fieldName)) {
            return this.moduleId != null && this.moduleId.equals(value);
        }
        if (OFFSET_ID.equals(fieldName)) {
            return this.offsetId != null && this.offsetId.equals(value);
        }
        if (DBRM_ID.equals(fieldName)) {
            return this.tdbrm != null && this.tdbrm.equals(value);
        }
        if (DBRMNR_ID.equals(fieldName)) {
            return this.tdbrmnr != null && this.tdbrmnr.equals(value);
        }
        if (MINOR_CAT_ID.equals(fieldName)) {
            return this.minorCatId != null && this.minorCatId.equals(value);
        }
        throw new IllegalArgumentException(String.format("Field name unknown or null: %s", fieldName));
    }

    public CallerIdRowModel clone() {
        CallerIdRowModel result = new CallerIdRowModel();
        result.outcalid = this.outcalid;
        result.outccsct = this.outccsct;
        result.outcoff = this.outcoff;
        result.stmt = this.stmt;
        result.function = this.function;
        result.total = this.total;
        result.taskId = this.taskId;
        result.moduleId = this.moduleId;
        result.csectId = this.csectId;
        result.tdbrm = this.tdbrm;
        result.tdbrmnr = this.tdbrmnr;
        result.minorCatId = this.minorCatId;
        return result;
    }

    public void addTotal(double percent) {
        this.total = this.total == null ? percent : this.total + percent;
    }

    public void addActive(double percent) {
        this.active = this.active == null ? percent : this.active + percent;
    }

    public void addWait(double percent) {
        this.wait = this.wait == null ? percent : this.wait + percent;
    }

    public void addRow(CallerIdRowModel callerRow) {
        this.total = this.total + callerRow.total;
        this.active = this.active + callerRow.active;
        this.wait = this.wait + callerRow.wait;
    }

    public String getCsectId() {
        return this.csectId;
    }

    public String getOutCsect() {
        return this.outccsct;
    }

    public String getOutModule() {
        return this.outcalid;
    }

    public String getOutOffset() {
        return this.outcoff;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setStatement(Integer statement) {
        this.stmt = statement;
    }

    public Integer getStatement() {
        return this.stmt;
    }

    public void setOutOffset(String outcoff) {
        this.outcoff = outcoff;
    }

    public double getTotal() {
        return this.total;
    }

    public double getActive() {
        return this.active;
    }

    public double getWait() {
        return this.wait;
    }

    public void setCount(int cnt) {
        this.count = cnt;
    }

    public int getCount() {
        return this.count;
    }

    public String getOutcalid() {
        return this.outcalid;
    }

    public void setOutcalid(String outcalid) {
        this.outcalid = outcalid;
    }

    public String getOutccsct() {
        return this.outccsct;
    }

    public void setOutccsct(String outccsct) {
        this.outccsct = outccsct;
    }

    public String getOutcoff() {
        return this.outcoff;
    }

    public void setOutcoff(String outcoff) {
        this.outcoff = outcoff;
    }
}

