/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.rowmodels;

import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableRow;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;

public class LogViewRowModel
extends MATTableRow {
    String level;
    String message;
    Date datetime;
    List<String> details;
    DateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss");

    public LogViewRowModel(MATTableModel model, String level, String message, Date datetime) {
        this(model, level, message, datetime, new ArrayList<String>());
    }

    public LogViewRowModel(MATTableModel model, String level, String message, Date datetime, List<String> details) {
        super(model);
        this.level = level;
        this.message = message;
        this.datetime = datetime;
        this.details = details;
    }

    @Override
    protected Object[] getArray() {
        return new Object[]{this.level, this.message, this.datetime};
    }

    public String getMessage() {
        return this.message;
    }

    public List<String> getDetails() {
        return this.details;
    }

    public int getStatus() {
        if (this.level.equals(Level.SEVERE.getName())) {
            return 4;
        }
        if (this.level.equals(Level.WARNING.getName())) {
            return 2;
        }
        return 1;
    }

    public String getDateTimeStr() {
        return this.dateFormat.format(this.datetime);
    }

    public String getLevel() {
        return this.level;
    }
}

