/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.views.subpages;

import com.ca.mat.common.table.IMATTableViewer;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.managers.AnalysisUtils;
import com.ca.mat.managers.Singletons;
import com.ca.mat.views.pages.AnalysisPageCalculated;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class HistogramSubpage
extends AnalysisPageCalculated {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    Logger log = Logger.getLogger(this.getClass().getName());
    private static final String VIEWER_MEMENTO_TYPE_OFFSET = "pages.histogram.viewer_offset";
    private static final String VIEWER_MEMENTO_TYPE_STATEMENT = "pages.histogram.viewer_statement";
    private static final String VIEWER_MEMENTO_TYPE_4GL = "pages.histogram.viewer_4gl";
    public static final String CONTEXT_HELP_ID = "com.ca.mat.help.histogram";
    public static final String ID = "com.ca.mat.subpages.histogram";
    static final String AUTONAV_COMMAND_ID = "com.ca.mat.commands.analysis.histogram.listing";
    public static final int MODE_4GL = 0;
    public static final int MODE_OFFSET = 1;
    public static final int MODE_STATEMENT = 2;
    private Composite groupControlComposite;
    private Label groupLabel;
    private Text groupText;
    private Button groupButton;
    private Button checkboxNormalize;
    private Button checkboxStatement;
    private int groupSize = 32;
    private boolean normalized = false;
    private int mode = 1;
    MATTableModel original;
    MATTableModel originalStatement;
    IMATTableViewer myViewer;
    Double totalDelay;

    @Override
    protected void setUpViewer(IMATTableViewer viewer) {
        this.myViewer = viewer;
        viewer.addColumn("Csect", 5, "Csect", 1, true, true);
        viewer.addColumn("Offset", 5, "Offset", 10, true, true);
        viewer.addColumn("Length", 3, "Length", 2, true, true);
        viewer.addColumn("Stmt", 5, "Stmt ", 12, true, true);
        viewer.addColumn("Verb", 7, "Verb", 1, true, true);
        viewer.addColumn("Active %", 4, "Active %", 9, true, true);
        viewer.addColumn("Wait %", 4, "Wait %", 9, true, true);
        viewer.addColumn("Total %", 4, "Total %", 9, true, true);
        viewer.addColumn("Source line", 9, "Source line", 1, true, true);
        if (this.mode == 1) {
            if (this.originalStatement == null) {
                viewer.setColumnEmpty(3);
            }
            viewer.setColumnEmpty(4);
            viewer.setColumnEmpty(8);
            viewer.setDefaultSortColumn(1);
            viewer.setDefaultSortDirection(128);
        } else if (this.mode == 2) {
            viewer.setColumnEmpty(1);
            viewer.setColumnEmpty(2);
            viewer.setColumnEmpty(8);
            viewer.setDefaultSortColumn(3);
            viewer.setDefaultSortDirection(128);
        } else if (this.mode == 0) {
            viewer.setColumnEmpty(0);
            viewer.setColumnEmpty(1);
            viewer.setColumnEmpty(2);
            viewer.setDefaultSortColumn(3);
            viewer.setDefaultSortDirection(128);
        } else {
            throw new IllegalArgumentException(String.format("Invalid Histogram mode: %s", this.mode));
        }
    }

    @Override
    public void createHeaderPart(Composite parent) {
        Composite wrapper = new Composite(parent, 0);
        wrapper.setLayout((Layout)new RowLayout());
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        wrapper.setLayoutData((Object)gridData);
        this.groupControlComposite = new Composite(wrapper, 0);
        this.groupControlComposite.setLayout((Layout)new GridLayout(3, false));
        gridData = new GridData();
        gridData.verticalIndent = 0;
        this.groupLabel = new Label(this.groupControlComposite, 4);
        this.groupLabel.setText("Group Size:");
        gridData.widthHint = this.groupLabel.computeSize((int)-1, (int)-1).x;
        this.groupLabel.setLayoutData((Object)gridData);
        this.groupText = new Text(this.groupControlComposite, 16384);
        this.groupText.setTextLimit(50);
        this.groupText.setLayoutData((Object)gridData);
        this.groupText.addListener(14, new Listener(){

            public void handleEvent(Event e) {
                HistogramSubpage.this.changeGroupSize();
            }
        });
        this.groupButton = new Button(this.groupControlComposite, 0x800000);
        this.groupButton.setText("Set");
        this.groupButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                HistogramSubpage.this.changeGroupSize();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite group3 = new Composite(wrapper, 0);
        group3.setLayout((Layout)new RowLayout());
        this.checkboxNormalize = new Button(group3, 32);
        this.checkboxNormalize.setText("Normalized");
        this.checkboxNormalize.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                HistogramSubpage.this.normalized = HistogramSubpage.this.checkboxNormalize.getSelection();
                try {
                    MATTableModel model;
                    if (HistogramSubpage.this.mode == 1 && HistogramSubpage.this.original != null && HistogramSubpage.this.groupSize != 0) {
                        model = AnalysisUtils.resizeHistogram(HistogramSubpage.this.original, HistogramSubpage.this.groupSize);
                        if (HistogramSubpage.this.normalized) {
                            model = AnalysisUtils.normalizeHistogram(model, HistogramSubpage.this.totalDelay);
                        }
                        HistogramSubpage.this.myViewer.setCATableModel(model);
                    }
                    if (HistogramSubpage.this.mode == 2) {
                        model = HistogramSubpage.this.originalStatement;
                        if (HistogramSubpage.this.normalized) {
                            model = AnalysisUtils.normalizeHistogram(model, HistogramSubpage.this.totalDelay);
                        }
                        HistogramSubpage.this.myViewer.setCATableModel(model);
                    }
                    if (HistogramSubpage.this.mode == 0) {
                        model = HistogramSubpage.this.original;
                        if (HistogramSubpage.this.normalized) {
                            model = AnalysisUtils.normalizeHistogram(model, HistogramSubpage.this.totalDelay);
                        }
                        HistogramSubpage.this.myViewer.setCATableModel(model);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.checkboxStatement = new Button(group3, 32);
        this.checkboxStatement.setText("Statement");
        this.checkboxStatement.setEnabled(false);
        this.checkboxStatement.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (HistogramSubpage.this.checkboxStatement.getSelection()) {
                    HistogramSubpage.this.setMode(2);
                } else {
                    HistogramSubpage.this.setMode(1);
                }
                try {
                    if (HistogramSubpage.this.mode == 1 && HistogramSubpage.this.original != null && HistogramSubpage.this.groupSize != 0) {
                        MATTableModel model = AnalysisUtils.resizeHistogram(HistogramSubpage.this.original, HistogramSubpage.this.groupSize);
                        if (HistogramSubpage.this.normalized) {
                            model = AnalysisUtils.normalizeHistogram(model, HistogramSubpage.this.totalDelay);
                        }
                        HistogramSubpage.this.myViewer.setCATableModel(model);
                    }
                    if (HistogramSubpage.this.mode == 2) {
                        if (HistogramSubpage.this.normalized) {
                            HistogramSubpage.this.myViewer.setCATableModel(AnalysisUtils.normalizeHistogram(HistogramSubpage.this.originalStatement, HistogramSubpage.this.totalDelay));
                        } else {
                            HistogramSubpage.this.myViewer.setCATableModel(HistogramSubpage.this.originalStatement);
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void changeGroupSize() {
        if (this.groupText.getText() == null) {
            return;
        }
        if (this.groupText.getText().toLowerCase().equals("stmt") && this.originalStatement != null) {
            this.setMode(2);
        } else {
            try {
                int size = Integer.valueOf(this.groupText.getText());
                if (size > 1 && size < 1000000) {
                    this.setMode(1);
                    this.setGroupSize(size);
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {}
            String message = "'%s' is not a valid group size - group size must be a number between 2 and 999999";
            if (this.originalStatement != null) {
                message = String.valueOf(message) + " or 'stmt'";
            }
            MessageDialog.openWarning(null, (String)"Invalid group size", (String)String.format(message, this.groupText.getText()));
            if (this.mode != 1) {
                this.groupText.setText("STMT");
            } else {
                this.groupText.setText("" + this.groupSize);
            }
        }
    }

    @Override
    public void setModel(MATTableModel original) {
        this.original = original;
    }

    public void setStatementModel(MATTableModel originalStatement) {
        this.originalStatement = originalStatement;
        this.checkboxStatement.setEnabled(true);
    }

    public void setGroupSize(int size) {
        if (this.mode == 1) {
            if (size > 0) {
                this.groupSize = size;
                this.groupText.setText("" + size);
                if (this.original != null) {
                    MATTableModel model = AnalysisUtils.resizeHistogram(this.original, this.groupSize);
                    if (this.normalized) {
                        model = AnalysisUtils.normalizeHistogram(model, this.totalDelay);
                    }
                    this.myViewer.setCATableModel(model);
                }
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setMode(int mode) {
        if (this.mode != mode) {
            Singletons.getViewerSynchronizationManager().removeViewer(this.myViewer);
            this.mode = mode;
            this.groupText.setText(mode == 1 ? "" + this.groupSize : "STMT");
            this.myViewer.setColumnEmpty(0, mode == 0);
            this.myViewer.setColumnEmpty(1, mode != 1);
            this.myViewer.setColumnEmpty(2, mode != 1);
            this.myViewer.setColumnEmpty(3, mode == 1 && this.originalStatement == null);
            this.myViewer.setColumnEmpty(4, mode != 2);
            this.myViewer.setColumnEmpty(8, mode != 0);
            this.myViewer.setDefaultSortColumn(mode == 1 ? 1 : 3);
            Singletons.getViewerSynchronizationManager().addViewer(this.getViewerMementoType(), this.myViewer);
            this.checkboxStatement.setVisible(mode != 0);
            this.checkboxStatement.setSelection(mode != 1);
            this.groupText.setEnabled(mode != 0);
            this.groupButton.setEnabled(mode != 0);
        }
        if (mode == 1 && this.original != null && this.groupSize != 0) {
            MATTableModel model = AnalysisUtils.resizeHistogram(this.original, this.groupSize);
            if (this.normalized) {
                model = AnalysisUtils.normalizeHistogram(model, this.totalDelay);
            }
            this.myViewer.setCATableModel(model);
        }
        if (mode == 2) {
            if (this.normalized) {
                this.myViewer.setCATableModel(AnalysisUtils.normalizeHistogram(this.originalStatement, this.totalDelay));
            } else {
                this.myViewer.setCATableModel(this.originalStatement);
            }
        }
        if (mode == 0) {
            if (this.normalized) {
                this.myViewer.setCATableModel(AnalysisUtils.normalizeHistogram(this.original, this.totalDelay));
            } else {
                this.myViewer.setCATableModel(this.original);
            }
        }
    }

    public void setTotalDelay(Double totalDelay) {
        this.totalDelay = totalDelay;
    }

    @Override
    public String getContextHelpId() {
        return CONTEXT_HELP_ID;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getViewerMementoType() {
        if (this.mode == 1) {
            return VIEWER_MEMENTO_TYPE_OFFSET;
        }
        if (this.mode == 2) {
            return VIEWER_MEMENTO_TYPE_STATEMENT;
        }
        if (this.mode == 0) {
            return VIEWER_MEMENTO_TYPE_4GL;
        }
        return null;
    }

    @Override
    protected String getAutonavigationCommandId() {
        return AUTONAV_COMMAND_ID;
    }

    @Override
    public void dispose() {
        this.original = null;
        this.originalStatement = null;
        super.dispose();
    }
}

