/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.dialogs;

import com.ca.mat.Activator;
import com.ca.mat.ServerWatch;
import com.ca.mat.connect.MATServer;
import com.ca.mat.connect.ValidateCredentials;
import com.ca.mat.dialogs.IUserLogonDialog;
import com.ca.mat.dialogs.MATErrorDialog;
import com.ca.mat.dialogs.TestingToolsDialog;
import com.ca.mat.managers.Singletons;
import com.ca.mat.utils.HexUtil;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;

public class UserLogonDialog
extends TestingToolsDialog
implements Listener,
IUserLogonDialog {
    static String cacopyright = "Copyright \u00a9 2017 CA";
    private static final String CHECK_HERE = "Check here if you want to save this password, so that you don't have to type it again the next time you are prompted for it.";
    private static final String ENTER_PASSWORD = "Enter Password";
    private static final String ENTER_USER_NAME = "Enter User Name";
    private Text userid;
    private MATServer server;
    private Text password;
    private Button savepswd;
    private Text message;
    private static final Bundle bundle = Activator.plugin.getBundle();
    private String errorText = "";
    private int errorResult = 0;
    private String reason;
    private static final boolean savepassword = Boolean.getBoolean("com.ca.testingtools.savepassword");

    public UserLogonDialog() {
        super(null);
        this.CONTEXT_HELP_ID = "com.ca.testingtools.help.userlogon";
    }

    public void setServer(MATServer server) {
        this.server = server;
    }

    protected int getDialogBoundsStrategy() {
        return 0;
    }

    protected Control createDialogArea(Composite parent) {
        int width;
        Point extent;
        this.getShell().setFont(JFaceResources.getHeaderFont());
        this.getShell().setText("Logon Information");
        Composite superComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(superComposite, 4);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setFont(JFaceResources.getDialogFont());
        Label label = new Label(composite, 1);
        label.setText(this.server.getName());
        GridData data = new GridData(32);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        GC gc = new GC((Drawable)label);
        Point point = gc.stringExtent(this.server.getName());
        data.minimumWidth = point.x;
        data.widthHint = point.x;
        gc.dispose();
        label = new Label(composite, 0);
        label.setText("&User ID");
        this.userid = new Text(composite, 2048);
        data = new GridData();
        gc = new GC((Drawable)this.userid);
        try {
            Point extent2 = gc.textExtent("W");
            data.widthHint = 8 * extent2.x;
        }
        finally {
            gc.dispose();
        }
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 1;
        this.userid.setLayoutData((Object)data);
        String useridString = this.server.getUser();
        if (useridString.isEmpty()) {
            useridString = System.getenv("USERNAME");
        }
        if (useridString == null) {
            useridString = "";
        }
        this.userid.setText(useridString);
        label = new Label(composite, 0);
        label.setText("&Password");
        this.password = new Text(composite, 0x400800);
        data = new GridData();
        gc = new GC((Drawable)this.password);
        try {
            extent = gc.textExtent("W");
            data.widthHint = 8 * extent.x;
        }
        finally {
            gc.dispose();
        }
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 1;
        this.password.setLayoutData((Object)data);
        if (this.server.isSavepassword()) {
            String result = savepassword ? HexUtil.decryptPassword((String)this.server.getUser(), (String)this.server.getEPassword()) : "";
            this.password.setText(result);
        } else {
            this.password.setText("");
        }
        if (savepassword) {
            this.savepswd = new Button(composite, 32);
            this.savepswd.setSelection(this.server.isSavepassword());
            this.savepswd.setText("Save Password");
            data = new GridData();
            data.horizontalSpan = 2;
            this.savepswd.setLayoutData((Object)data);
            this.savepswd.addListener(24, (Listener)this);
        } else {
            this.server.setSavepassword(false);
        }
        this.userid.addListener(24, (Listener)this);
        this.password.addListener(24, (Listener)this);
        if (savepassword) {
            Label sText = new Label(composite, 72);
            data = new GridData();
            data.horizontalSpan = 2;
            data.grabExcessHorizontalSpace = false;
            data.grabExcessVerticalSpace = true;
            data.verticalAlignment = 1;
            data.widthHint = 30 * extent.x;
            sText.setLayoutData((Object)data);
            sText.setText(CHECK_HERE);
        }
        if (this.userid.getText().length() == 0) {
            this.userid.setFocus();
        } else {
            this.password.setFocus();
        }
        this.message = new Text(composite, 9);
        this.message.setText(ENTER_USER_NAME);
        data = new GridData(32);
        data.horizontalSpan = 2;
        this.message.setLayoutData((Object)data);
        gc = new GC((Drawable)this.message);
        point = gc.stringExtent(ENTER_USER_NAME);
        Point point2 = gc.stringExtent(ENTER_PASSWORD);
        data.minimumWidth = width = Math.max(point.x, point2.x);
        data.widthHint = width;
        gc.dispose();
        return composite;
    }

    public void handleEvent(Event event) {
        this.checkButtons();
    }

    private void checkButtons() {
        boolean ok = true;
        String text = "";
        if ("".equals(this.userid.getText().trim())) {
            text = ENTER_USER_NAME;
            ok = false;
        } else if ("".equals(this.password.getText().trim())) {
            text = ENTER_PASSWORD;
            ok = false;
        }
        this.message.setText(text);
        this.getButton(0).setEnabled(ok);
    }

    protected void okPressed() {
        String passwordStr = this.password.getText().trim();
        this.server.setPassword(passwordStr);
        this.server.setUser(this.userid.getText().trim());
        if (savepassword) {
            this.server.setSavepassword(this.savepswd.getSelection());
        }
        ValidateCredentials validate = new ValidateCredentials(this.server);
        this.errorResult = validate.run(true);
        if (this.errorResult == 0) {
            ServerWatch watch = Singletons.getServerWatch((Display)Display.getCurrent());
            watch.startThread();
            super.okPressed();
        } else {
            this.reason = "Could not login into CA MAT, your login or password may be invalid";
            MATErrorDialog.openError(null, (String)"Signon Error", (String)validate.getErrorMessage(), (Throwable)new Throwable(this.reason));
            this.setReturnCode(-1);
            this.errorText = validate.getErrorMessage();
        }
    }

    protected void cancelPressed() {
        this.errorResult = 0;
        this.errorText = "";
        this.reason = "User cancelled login";
        super.cancelPressed();
    }

    public void create() {
        super.create();
        this.checkButtons();
    }

    protected Bundle getBundle() {
        return bundle;
    }

    public String getErrorText() {
        return this.errorText;
    }

    public int getErrorResult() {
        return this.errorResult;
    }

    public String getReason() {
        return this.reason;
    }
}

