/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.rcp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;

public class ShowViewMenu
extends ContributionItem {
    static String cacopyright = "Copyright \u00a9 2017 CA";
    protected boolean dirty = true;
    private IWorkbenchWindow window;
    private IMenuListener menuListener = new IMenuListener(){

        public void menuAboutToShow(IMenuManager manager) {
            manager.markDirty();
            ShowViewMenu.this.dirty = true;
        }
    };

    public ShowViewMenu(IWorkbenchWindow window, String id) {
        super(id);
        this.window = window;
    }

    public void fill(Menu menu, int index) {
        IContributionItem[] iContributionItemArray;
        if (this.getParent() instanceof MenuManager) {
            ((MenuManager)this.getParent()).addMenuListener(this.menuListener);
        }
        if (!this.dirty) {
            return;
        }
        IWorkbenchPage page = this.window.getActivePage();
        if (page == null) {
            return;
        }
        IPerspectiveDescriptor perspective = page.getPerspective();
        if (perspective == null) {
            return;
        }
        List<String> viewIds = Arrays.asList(page.getShowViewShortcuts());
        MenuManager manager = new MenuManager();
        manager.removeAll();
        ArrayList<ShowViewAction> actions = new ArrayList<ShowViewAction>(viewIds.size());
        ShowViewAction action = null;
        IViewRegistry reg = PlatformUI.getWorkbench().getViewRegistry();
        for (String string : viewIds) {
            action = null;
            IViewDescriptor desc = reg.find(string);
            if (desc != null) {
                action = new ShowViewAction(this.window, desc);
                action.setActionDefinitionId(string);
            }
            if (action == null) continue;
            actions.add(action);
        }
        for (IAction iAction : actions) {
            manager.add(iAction);
        }
        IContributionItem[] iContributionItemArray2 = iContributionItemArray = manager.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem element = iContributionItemArray2[n2];
            element.fill(menu, index++);
            ++n2;
        }
        this.dirty = false;
    }

    public boolean isDynamic() {
        return true;
    }

    public class ShowViewAction
    extends Action
    implements IPluginContribution {
        private IWorkbenchWindow window;
        private IViewDescriptor desc;

        protected ShowViewAction(IWorkbenchWindow window, IViewDescriptor desc) {
            super("");
            String accel = null;
            String label = desc.getLabel();
            this.setText(accel == null ? label : String.valueOf(label) + "@" + accel);
            this.setImageDescriptor(desc.getImageDescriptor());
            this.setToolTipText(label);
            this.window = window;
            this.desc = desc;
        }

        public void run() {
            IWorkbenchPage page = this.window.getActivePage();
            if (page != null) {
                try {
                    page.showView(this.desc.getId());
                }
                catch (PartInitException partInitException) {}
            }
        }

        public String getLocalId() {
            return this.desc.getId();
        }

        public String getPluginId() {
            return this.desc instanceof IPluginContribution ? ((IPluginContribution)this.desc).getPluginId() : null;
        }
    }
}

