/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.connect;

import com.ca.mat.MATException;
import com.ca.mat.Messages;
import com.ca.mat.connect.MATFamily;
import com.ca.mat.connect.MATLoginCancelledException;
import com.ca.mat.connect.MATSecurityException;
import com.ca.mat.connect.MATServer;
import com.ca.mat.connect.ServerCallback;
import com.ca.mat.connect.ServerConnect;
import com.ca.mat.connect.ServerProxy;
import com.ca.mat.logging.Logging;
import com.ca.mat.managers.Singletons;
import com.ca.mat.xml.XMLRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;

public class ServerJob
extends Job
implements IJobChangeListener {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    public static final String ERROR_MESSAGE_GENERIC = "Server error";
    public static final String ERROR_MESSAGE_LOGIN = "Login failed";
    private MATServer server;
    private String command;
    private Map<String, Object> map;
    private String uuid;
    protected Display display;
    private boolean canceling = false;
    protected ServerCallback callback;
    private boolean required = false;
    private boolean printOutXML = Boolean.getBoolean("com.ca.mat.connect.ServerJob.outputAllXML");
    Logger log;
    private ServerConnect connect = null;

    public ServerJob(String name, MATServer server, String command, Map<String, Object> map, ServerCallback callback, Display display) {
        super(name);
        this.server = server;
        this.command = command;
        this.map = map;
        this.callback = callback;
        this.display = display;
        this.uuid = UUID.randomUUID().toString();
        map.put("uuid", this.uuid);
        map.put("request-description", name);
        this.addJobChangeListener(this);
        this.log = Logging.getLogger(server.getDisplay());
    }

    public String getUUID() {
        return this.uuid;
    }

    public void aboutToRun(IJobChangeEvent event) {
    }

    public void awake(IJobChangeEvent event) {
    }

    public void done(IJobChangeEvent event) {
    }

    public void running(IJobChangeEvent event) {
    }

    public void scheduled(IJobChangeEvent event) {
    }

    public void sleeping(IJobChangeEvent event) {
    }

    protected IStatus run(IProgressMonitor monitor) {
        XMLRequest reply = null;
        try {
            this.log.log(Level.FINE, String.format(Messages.serverCommandSent, this.command));
            this.connect = new ServerConnect(this.server, "mat/server");
            reply = this.connect.connect(this.command, this.map, true);
            if (reply == null) {
                return Status.CANCEL_STATUS;
            }
            if (reply.hasAttachedFile()) {
                Singletons.getTempFilesManager(this.display).registerTempFile(reply.getAttachedFile());
            }
            this.log.log(Level.FINE, String.format(Messages.serverCommandResponse, this.command), reply.toString());
            int errorLvl = reply.getErrorLevel();
            if (errorLvl > 4) {
                if ("TUNT9000".equals(reply.getErrorNumber())) {
                    Singletons.getServerProxy(this.display).cancelCallback(this.callback, this.server, reply, this.command, this.display);
                    return Status.CANCEL_STATUS;
                }
                throw new MATException(reply);
            }
            final XMLRequest finalReply = reply;
            if (errorLvl == 4) {
                this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning(null, (String)"Server request succeeded with warning", (String)finalReply.getErrorMessage());
                    }
                });
            }
            if (this.canceling) {
                this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (ServerJob.this.printOutXML) {
                            finalReply.toFile(System.out, true);
                        }
                        if (ServerJob.this.callback != null) {
                            ServerJob.this.callback.cancel(finalReply, ServerJob.this.server);
                        }
                    }
                });
            } else {
                this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (ServerJob.this.printOutXML) {
                            finalReply.toFile(System.out, true);
                        }
                        if (ServerJob.this.callback != null) {
                            ServerJob.this.callback.processReply(finalReply, ServerJob.this.server);
                        }
                    }
                });
                this.logSuccess(reply);
            }
        }
        catch (MATLoginCancelledException e) {
            if (!this.display.isDisposed()) {
                Singletons.getServerProxy(this.display).disconnect(this.server);
                Singletons.getServerProxy(this.display).requestFailed(this.callback, this.server, reply, this.command, e, false, this.display, this.map);
            }
            return Status.CANCEL_STATUS;
        }
        catch (MATSecurityException e) {
            if (!this.display.isDisposed()) {
                Singletons.getServerProxy(this.display).disconnect(this.server);
                Singletons.getServerProxy(this.display).requestFailed(this.callback, this.server, reply, this.command, e, false, this.display, this.map);
            }
            return new Status(0, "com.ca.mat.plugin", ERROR_MESSAGE_LOGIN);
        }
        catch (MATException e) {
            if (!this.display.isDisposed()) {
                Singletons.getServerProxy(this.display).requestFailed(this.callback, this.server, reply, this.command, e, true, this.display, this.map);
            }
            return new Status(0, "com.ca.mat.plugin", ERROR_MESSAGE_GENERIC);
        }
        catch (SWTException e) {
            if ("Device is disposed".equals(e.getMessage())) {
                return Status.CANCEL_STATUS;
            }
            this.log.log(Level.SEVERE, String.format(Messages.serverCommandFailed, this.command), e);
            return new Status(0, "com.ca.mat.plugin", "Exception in UI");
        }
        return Status.OK_STATUS;
    }

    protected void canceling() {
        this.canceling = true;
        ServerConnect killconnect = new ServerConnect(this.server, "mat/server");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("uuid", this.uuid);
        map.put("jobname", this.getName());
        try {
            ServerProxy proxy = Singletons.getServerProxy(this.display);
            if (this.server.isActive() && proxy.isConnected(this.server)) {
                killconnect.connect("cancel", map, false);
                this.log.log(Level.INFO, String.format("Job %s %s Canceled", this.uuid, this.getName()));
            }
        }
        catch (MATException e) {
            e.printStackTrace();
        }
    }

    public boolean belongsTo(Object family) {
        MATFamily matFamily;
        if ("com.ca.mat".equals(family.toString())) {
            return true;
        }
        if (family instanceof MATServer && this.server.equals(family)) {
            return true;
        }
        if (family instanceof MATFamily && (matFamily = (MATFamily)family).getDisplay().equals(this.display)) {
            if (matFamily.getType() == 0) {
                return true;
            }
            if (matFamily.getType() == 2 && this.map.get("type") != null && this.map.get("type").equals("tunmon")) {
                return true;
            }
            if (matFamily.getType() == 3 && this.map.get("type") != null && this.map.get("type").equals("tunhist")) {
                return true;
            }
            if (matFamily.getType() == 4 && this.map.get("type") != null && this.map.get("type").equals("tunmtt")) {
                return true;
            }
        }
        return super.belongsTo(family);
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public MATServer getServer() {
        return this.server;
    }

    public void logSuccess(XMLRequest reply) {
        String command = reply.getCommandName();
        Logger log = Logging.getLogger(this.display);
        if ("analysis".equals(command)) {
            log.info("Analysis data loaded for monitor dataset " + this.map.get("DSN"));
        }
        if ("deletehistory".equals(command)) {
            log.info("History entry deleted for dsn " + this.map.get("DSN"));
        }
        if ("define".equals(command)) {
            log.info("Profile " + this.map.get("profile") + " created.");
        }
        if ("edit".equals(command)) {
            log.info("Profile " + this.map.get("profile") + " updated");
        }
        if ("delete".equals(command)) {
            log.info("Profile " + this.map.get("profile") + " deleted");
        }
        if ("invoke".equals(command)) {
            log.info("Profile " + this.map.get("profile") + " invoked");
        }
        if ("stop".equals(command)) {
            log.info("Profile " + this.map.get("profile") + " stopped");
        }
        if ("listing".equals(command)) {
            log.info("Listing downloaded for csect " + this.map.get("csect"));
        }
        if ("register".equals(command)) {
            log.info("Listing registered for csect " + this.map.get("csect"));
        }
    }
}

