/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.handlers;

import com.ca.mat.common.table.IMATTableViewer;
import com.ca.mat.managers.Singletons;
import com.ca.mat.managers.ViewerSynchronizationManager;
import com.ca.mat.views.LocalXMLFilesView;
import com.ca.mat.views.MonitorHistoryView;
import com.ca.mat.views.MonitorSchedulesView;
import com.ca.mat.views.MonitorTreeView;
import com.ca.mat.views.pages.AnalysisPage;
import com.ca.mat.views.pages.AnalysisPageBasic;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.ViewPart;

public class ResetViewHandler
extends AbstractHandler {
    static final String cacopyright = "Copyright \u00a9 2017 CA";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ViewPart view;
        IMATTableViewer viewer = null;
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        ViewerSynchronizationManager syncManager = Singletons.getViewerSynchronizationManager(HandlerUtil.getActiveShell((ExecutionEvent)event).getDisplay());
        if (part instanceof MonitorHistoryView) {
            view = (MonitorHistoryView)part;
            viewer = view.getViewer();
            syncManager.resetGroup("monitorhistoryview.viewer");
            this.resetFilter(viewer);
        }
        if (part instanceof LocalXMLFilesView) {
            view = (LocalXMLFilesView)part;
            viewer = view.getViewer();
            syncManager.resetGroup("localXMLFiles.viewer");
            this.resetFilter(viewer);
        }
        if (part instanceof MonitorTreeView) {
            view = (MonitorTreeView)part;
            viewer = view.getActiveTableViewer();
            syncManager.resetGroup("com.ca.mat.views.monitortreeview");
            this.resetFilter(viewer);
        }
        if (part instanceof MonitorSchedulesView) {
            view = (MonitorSchedulesView)part;
            viewer = view.getViewer();
            syncManager.resetGroup("monitorschedulesview.viewer");
            this.resetFilter(viewer);
        } else {
            AnalysisPage page = Singletons.getAnalysisManager().getFocusedAnalysisPage();
            page.getPresentation();
            if (page instanceof AnalysisPageBasic) {
                AnalysisPageBasic pageWithViewer = (AnalysisPageBasic)page;
                viewer = pageWithViewer.getViewer();
                this.resetFilter(viewer);
                String group = syncManager.findGroup(viewer);
                if (group != null) {
                    syncManager.resetGroup(group);
                }
            }
        }
        return null;
    }

    public void resetFilter(IMATTableViewer viewer) {
        viewer.removeAllFilters();
    }
}

