/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.handlers.analysis;

import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.managers.AnalysisUtils;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.CodeViewRowModel;
import com.ca.mat.views.AnalysisPagePresentationFactory;
import com.ca.mat.views.AnalysisTabbedView;
import com.ca.mat.views.IAnalysisPagePresentation;
import com.ca.mat.views.IAnalysisSubpagePresentation;
import com.ca.mat.views.pages.AnalysisPage;
import com.ca.mat.views.pages.AnalysisPageCalculated;
import com.ca.mat.views.pages.CodeViewPage;
import com.ca.mat.views.pages.DelayViewPage;
import com.ca.mat.views.pages.PageWithModesContainer;
import com.ca.mat.views.pages.ProgramViewPage;
import com.ca.mat.views.subpages.CallerIdSubpage;
import com.ca.mat.views.subpages.HistogramSubpage;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;

public class CodeViewNavigationHandler
extends AbstractHandler {
    static final String cacopyright = "Copyright \u00a9 2017 CA";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String commandId = event.getCommand().getId();
        AnalysisPage page = Singletons.getAnalysisManager().getFocusedAnalysisPage();
        ISelection sel = page.getSelectionProvider().getSelection();
        if (!(sel instanceof StructuredSelection)) {
            return null;
        }
        StructuredSelection sSel = (StructuredSelection)sel;
        Object obj = sSel.getFirstElement();
        IAnalysisPagePresentation presentation = page.getPresentation();
        int type = presentation.getAnalysisType();
        String dsn = presentation.getDSN();
        String profile = presentation.getProfile();
        if (obj instanceof CodeViewRowModel) {
            CodeViewRowModel rowModel = (CodeViewRowModel)obj;
            if (commandId.equals("com.ca.mat.commands.analysis.codeview.histogram")) {
                CodeViewPage codeView = (CodeViewPage)page;
                HashMap<String, Object[]> histogramArgs = new HashMap<String, Object[]>();
                histogramArgs.putAll(codeView.getFilterExpressions());
                ArrayList<String[]> histogramTitles = new ArrayList<String[]>();
                histogramTitles.addAll(codeView.getTitleExpressions());
                histogramArgs.put("Module", new Object[]{rowModel.getModule()});
                histogramArgs.put("Csect", new Object[]{rowModel.getCSECT()});
                histogramTitles.add(new String[]{"Module", rowModel.getModule()});
                histogramTitles.add(new String[]{"Csect", rowModel.getCSECT()});
                MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, "TimeView", type);
                model = model.filterBy(histogramArgs);
                MATTableModel statementModel = null;
                if (AnalysisUtils.csectHasStatements(dsn, rowModel.getCSECT())) {
                    statementModel = AnalysisUtils.calculateHistogramStatement(model, rowModel.getModule(), rowModel.getCSECT(), dsn, type, Display.getCurrent());
                }
                model = AnalysisUtils.calculateHistogramBase(model, dsn, type);
                IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(HistogramSubpage.class, "", dsn, type, presentation, "com.ca.mat.help.histogram", model);
                String partName = "Histogram:";
                for (String[] entry : histogramTitles) {
                    partName = String.valueOf(partName) + " " + entry[0] + " " + entry[1];
                }
                detachedView.setPresentationName(partName);
                AnalysisPage newPage = detachedView.getCurrentPage();
                if (newPage != null && newPage instanceof HistogramSubpage) {
                    HistogramSubpage histogramPage = (HistogramSubpage)newPage;
                    histogramPage.setGroupSize(32);
                    histogramPage.setTotalDelay(rowModel.getTotal());
                    if (statementModel != null) {
                        histogramPage.setStatementModel(statementModel);
                        histogramPage.setMode(2);
                    } else {
                        histogramPage.setMode(1);
                    }
                }
                return null;
            }
            if (commandId.equals("com.ca.mat.commands.analysis.codeview.callerid") && page instanceof CodeViewPage) {
                CodeViewPage codeView = (CodeViewPage)page;
                HashMap<String, Object[]> callerIdArgs = new HashMap<String, Object[]>();
                callerIdArgs.putAll(codeView.getFilterExpressions());
                ArrayList<String[]> callerIdTitles = new ArrayList<String[]>();
                callerIdTitles.addAll(codeView.getTitleExpressions());
                callerIdArgs.put("Module", new Object[]{rowModel.getModule()});
                callerIdArgs.put("Csect", new Object[]{rowModel.getCSECT()});
                callerIdTitles.add(new String[]{"Module", rowModel.getModule()});
                callerIdTitles.add(new String[]{"Csect", rowModel.getCSECT()});
                MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, "TimeView", type);
                Singletons.getAnalysisManager().getModel(dsn, "Call Stack Info", type);
                model = model.filterBy(callerIdArgs);
                model = AnalysisUtils.calculateCallerId(model, dsn, type, Display.getCurrent());
                IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(CallerIdSubpage.class, "", dsn, type, presentation, "com.ca.mat.help.callerid", model);
                String partName = "CallerId:";
                for (String[] entry : callerIdTitles) {
                    partName = String.valueOf(partName) + " " + entry[0] + " " + entry[1];
                }
                detachedView.setPresentationName(partName);
                AnalysisPage newPage = detachedView.getCurrentPage();
                if (newPage != null && newPage instanceof CallerIdSubpage) {
                    CallerIdSubpage callerIdPage = (CallerIdSubpage)newPage;
                    callerIdPage.setFilterExpressions(callerIdArgs);
                    callerIdPage.setTitleExpressions(callerIdTitles);
                }
                if (newPage != null && newPage instanceof AnalysisPageCalculated) {
                    ((AnalysisPageCalculated)newPage).refreshHeader();
                }
                return null;
            }
            if (commandId.equals("com.ca.mat.commands.analysis.codeview.delaydetails") && page instanceof CodeViewPage) {
                CodeViewPage codeView = (CodeViewPage)page;
                HashMap<String, Object[]> delayViewArgs = new HashMap<String, Object[]>();
                delayViewArgs.putAll(codeView.getFilterExpressions());
                ArrayList<String[]> delayViewTitles = new ArrayList<String[]>();
                delayViewTitles.addAll(codeView.getTitleExpressions());
                delayViewArgs.put("Module", new Object[]{rowModel.getModule()});
                delayViewTitles.add(new String[]{"Module", rowModel.getModule()});
                if (codeView.getModeType().equals(CodeViewRowModel.TYPE_CSECT)) {
                    delayViewArgs.put("Csect", new Object[]{rowModel.getCSECT()});
                    delayViewTitles.add(new String[]{"Csect", rowModel.getCSECT()});
                }
                MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, "TimeView", type);
                model = model.filterBy(delayViewArgs);
                model = AnalysisUtils.calculateDelayView(model, dsn, type);
                IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(DelayViewPage.class, "", dsn, type, presentation, "com.ca.mat.help.delaydetail", model);
                String partName = "Delay Detail:";
                for (String[] entry : delayViewTitles) {
                    partName = String.valueOf(partName) + " " + entry[0] + " " + entry[1];
                }
                detachedView.setPresentationName(partName);
                AnalysisPage newPage = detachedView.getCurrentPage();
                if (newPage != null && newPage instanceof DelayViewPage) {
                    DelayViewPage delayDetail = (DelayViewPage)newPage;
                    delayDetail.setFilterExpressions(delayViewArgs);
                    delayDetail.setTitleExpressions(delayViewTitles);
                }
                if (newPage != null && newPage instanceof AnalysisPageCalculated) {
                    ((AnalysisPageCalculated)newPage).refreshHeader();
                }
                return null;
            }
            if (commandId.equals("com.ca.mat.commands.analysis.codeview.listing")) {
                Singletons.getListingManager().showListing(presentation, rowModel.getModule(), rowModel.getCSECT(), null, dsn, page.getControl().getDisplay());
            }
            if (commandId.equals("com.ca.mat.commands.codeview.registerlisting")) {
                Singletons.getListingManager().startListingRegistration(page.getControl().getShell(), rowModel.getModule(), rowModel.getCSECT(), profile, dsn, null);
            }
        }
        if (page instanceof CodeViewPage) {
            CodeViewPage currentCodeView = (CodeViewPage)page;
            if (commandId.equals("com.ca.mat.commands.analysis.mode.codeview.csect")) {
                this.changeCodeViewMode(presentation, CodeViewRowModel.TYPE_CSECT, currentCodeView);
                return null;
            }
            if (commandId.equals("com.ca.mat.commands.analysis.mode.codeview.module")) {
                this.changeCodeViewMode(presentation, CodeViewRowModel.TYPE_MODULE, currentCodeView);
                return null;
            }
            if (commandId.equals("com.ca.mat.commands.analysis.mode.codeview.pseudo")) {
                this.changeCodeViewMode(presentation, CodeViewRowModel.TYPE_PSEUDO, currentCodeView);
                return null;
            }
            if (commandId.equals("com.ca.mat.commands.analysis.codeview.programview")) {
                HashMap<String, Object[]> programViewArgs = new HashMap<String, Object[]>();
                programViewArgs.putAll(currentCodeView.getFilterExpressions());
                ArrayList<String[]> programViewTitles = new ArrayList<String[]>();
                programViewTitles.addAll(currentCodeView.getTitleExpressions());
                MATTableModel originalModel = Singletons.getAnalysisManager().getModel(dsn, "TimeView", type);
                originalModel.filterBy(programViewArgs);
                MATTableModel model = AnalysisUtils.calculateCodeView(originalModel, dsn, type);
                IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(ProgramViewPage.class, "", dsn, type, presentation, "com.ca.mat.help.programview", model);
                String partName = "Program View ";
                for (String[] entry : programViewTitles) {
                    partName = String.valueOf(partName) + " " + entry[0] + " " + entry[1];
                }
                detachedView.setPresentationName(partName);
                AnalysisPage newPage = detachedView.getCurrentPage();
                if (newPage != null && newPage instanceof ProgramViewPage) {
                    ProgramViewPage programViewPage = (ProgramViewPage)newPage;
                    programViewPage.setOriginalModel(originalModel);
                }
                if (newPage != null && newPage instanceof AnalysisPageCalculated) {
                    ((AnalysisPageCalculated)newPage).refreshHeader();
                }
                return null;
            }
        }
        return null;
    }

    private void changeCodeViewMode(IAnalysisPagePresentation view, String newMode, CodeViewPage currentCodeView) {
        AnalysisTabbedView tabView;
        PageWithModesContainer pageContainer = currentCodeView.changeMode(newMode);
        boolean compare = Singletons.getCompareManager().getCompare();
        if (compare) {
            Singletons.getCompareManager().modeChanged(newMode);
        }
        view.addPage(pageContainer.getAnalysisPage(), true);
        ((CodeViewPage)pageContainer.getAnalysisPage()).setModel(pageContainer.getModel());
        view.showPage(pageContainer.getAnalysisPage());
        if (view instanceof AnalysisTabbedView && currentCodeView.equals((tabView = (AnalysisTabbedView)view).getPage("Code"))) {
            return;
        }
        Singletons.getAnalysisManager().analysisPageFocused(pageContainer.getAnalysisPage());
        currentCodeView.dispose();
    }
}

