/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.handlers.analysis;

import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableRow;
import com.ca.mat.managers.AnalysisUtils;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.TimeViewRowModel;
import com.ca.mat.rowmodels.tuntables.TundelayRowModel;
import com.ca.mat.views.AnalysisPagePresentationFactory;
import com.ca.mat.views.IAnalysisPagePresentation;
import com.ca.mat.views.IAnalysisSubpagePresentation;
import com.ca.mat.views.pages.AnalysisPage;
import com.ca.mat.views.subpages.DelayedResourceSubpage;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class TimeViewNavigationHandler
extends AbstractHandler {
    static final String cacopyright = "Copyright \u00a9 2017 CA";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String commandId = event.getCommand().getId();
        AnalysisPage page = Singletons.getAnalysisManager().getFocusedAnalysisPage();
        ISelection sel = page.getSelectionProvider().getSelection();
        if (!(sel instanceof StructuredSelection)) {
            return null;
        }
        StructuredSelection sSel = (StructuredSelection)sel;
        Object obj = sSel.getFirstElement();
        IAnalysisPagePresentation presentation = page.getPresentation();
        int type = presentation.getAnalysisType();
        String dsn = presentation.getDSN();
        presentation.getProfile();
        if (obj instanceof TimeViewRowModel) {
            TimeViewRowModel timeRow = (TimeViewRowModel)obj;
            if (commandId.equals("com.ca.mat.commands.analysis.timeview.details")) {
                String section = "TimeView-Delayed Resources";
                MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, "TimeView", type);
                model = AnalysisUtils.calculateDelayedResource(timeRow.getObsNumber(), model, dsn, type);
                IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(DelayedResourceSubpage.class, section, dsn, type, presentation, "com.ca.mat.help.delayedresources", model);
                detachedView.setPresentationName(String.format("Delayed Resources for observation %s", timeRow.getObsNumber()));
                AnalysisPage newPage = detachedView.getCurrentPage();
                if (newPage != null && newPage instanceof DelayedResourceSubpage) {
                    DelayedResourceSubpage delayResPage = (DelayedResourceSubpage)newPage;
                    MATTableModel delayTable = Singletons.getAnalysisManager().getStaticModel("TUNDELAY");
                    String mincatString = "";
                    MATTableRow[] mATTableRowArray = delayTable.getRows();
                    int n = mATTableRowArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MATTableRow row = mATTableRowArray[n2];
                        TundelayRowModel delayRow = (TundelayRowModel)row;
                        if (delayRow.getType1().equals(timeRow.getDelayType1()) && delayRow.getType2().equals(timeRow.getDelayType2())) {
                            mincatString = delayRow.getDescription();
                        }
                        ++n2;
                    }
                    delayResPage.setHeaderContent(mincatString, timeRow.getModule(), timeRow.getCsect(), timeRow.getOffset());
                }
                return null;
            }
        }
        return null;
    }
}

