/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.handlers.analysis;

import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableRow;
import com.ca.mat.managers.AnalysisUtils;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.WASSQLRowModel;
import com.ca.mat.rowmodels.WASTranDelayRowModel;
import com.ca.mat.rowmodels.WASViewRowModel;
import com.ca.mat.views.AnalysisPagePresentationFactory;
import com.ca.mat.views.AnalysisTabbedView;
import com.ca.mat.views.IAnalysisPagePresentation;
import com.ca.mat.views.IAnalysisSubpagePresentation;
import com.ca.mat.views.pages.AnalysisPage;
import com.ca.mat.views.pages.PageWithModesContainer;
import com.ca.mat.views.pages.WASViewPage;
import com.ca.mat.views.subpages.AbstractWASSubpage;
import com.ca.mat.views.subpages.TextDisplaySubpage;
import com.ca.mat.views.subpages.WASClassSubpage;
import com.ca.mat.views.subpages.WASDelaysSubpage;
import com.ca.mat.views.subpages.WASSQLDisplaySubpage;
import com.ca.mat.views.subpages.WASSQLSubpage;
import com.ca.mat.views.subpages.WASTransSubpage;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class WASViewNavigationHandler
extends AbstractHandler {
    static final String cacopyright = "Copyright \u00a9 2017 CA";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String location;
        MATTableRow rowModel;
        String commandId = event.getCommand().getId();
        AnalysisPage page = Singletons.getAnalysisManager().getFocusedAnalysisPage();
        ISelection sel = page.getSelectionProvider().getSelection();
        if (!(sel instanceof StructuredSelection)) {
            return null;
        }
        StructuredSelection sSel = (StructuredSelection)sel;
        Object obj = sSel.getFirstElement();
        IAnalysisPagePresentation presentation = page.getPresentation();
        int type = presentation.getAnalysisType();
        String dsn = presentation.getDSN();
        WASViewPage.WASContextRestrictions currentContext = null;
        if (commandId.equals("com.ca.mat.commands.analysis.wasdelays") && (page instanceof WASViewPage || page instanceof AbstractWASSubpage)) {
            String section = "WAS Tran Delay";
            String aggregateMode = "group_by_delay";
            String dataMode = null;
            String displayMode = "display_mode_delay";
            HashMap<String, Object[]> arguments = new HashMap<String, Object[]>();
            if (page instanceof AbstractWASSubpage) {
                dataMode = ((WASTranDelayRowModel)obj).getDataMode();
                WASTranDelayRowModel row = (WASTranDelayRowModel)obj;
                currentContext = ((AbstractWASSubpage)page).getContextRestrictions();
                arguments.put("tranurl", new Object[]{currentContext.getWASTransaction()});
                if (dataMode.equals("data_mode_application")) {
                    arguments.put("wasmetha", new Object[]{row.getMethodName()});
                    arguments.put("wasclssa", new Object[]{row.getClassName()});
                    arguments.put("waslinea", new Object[]{row.getLine()});
                    currentContext.setWASMethodNameKey("wasmetha");
                    currentContext.setWASClassNameKey("wasclssa");
                    currentContext.setLineNumberKey("waslinea");
                } else if (dataMode.equals("data_mode_current")) {
                    arguments.put("wasmethc", new Object[]{row.getMethodName()});
                    arguments.put("wasclssc", new Object[]{row.getClassName()});
                    arguments.put("waslinec", new Object[]{row.getLine()});
                    currentContext.setWASMethodNameKey("wasmethc");
                    currentContext.setWASClassNameKey("wasmethc");
                    currentContext.setLineNumberKey("waslinec");
                } else if (dataMode.equals("data_mode_via")) {
                    arguments.put("wasmethv", new Object[]{row.getMethodName()});
                    arguments.put("wasclssv", new Object[]{row.getClassName()});
                    arguments.put("waslinev", new Object[]{row.getLine()});
                    currentContext.setWASMethodNameKey("wasmethv");
                    currentContext.setWASClassNameKey("wasclssv");
                    currentContext.setLineNumberKey("waslinev");
                } else {
                    String format = "%1$s: command(%2$s), row dataMode(%3$s) - INVALID COMBINATION";
                    throw new RuntimeException(String.format(format, ((Object)((Object)this)).getClass().toString(), commandId, row.getDataMode()));
                }
                currentContext.setDataMode(dataMode);
                currentContext.setWASMethodNameTranslated(row.getMethodNameTranslated());
                currentContext.setWASMethodNameId(row.getMethodName());
                currentContext.setWASClassNameTranslated(row.getClassNameTranslated());
                currentContext.setWASClassNameId(row.getClassName());
                currentContext.setLineNumber(row.getLine());
            } else if (page instanceof WASViewPage) {
                MATTableRow rowModel2;
                if (obj instanceof WASViewRowModel) {
                    rowModel2 = (WASViewRowModel)obj;
                    dataMode = "data_mode_application";
                    arguments.put("tranurl", new Object[]{((WASViewRowModel)rowModel2).getURLName()});
                    currentContext = new WASViewPage.WASContextRestrictions();
                    currentContext.setWASTransaction(((WASViewRowModel)rowModel2).getURLName());
                    currentContext.setWASTransactionTranslated(((WASViewRowModel)rowModel2).getURLNameTranslated());
                } else if (obj instanceof WASTranDelayRowModel) {
                    rowModel2 = (WASTranDelayRowModel)obj;
                    dataMode = ((WASTranDelayRowModel)rowModel2).getDataMode();
                    currentContext = new WASViewPage.WASContextRestrictions();
                    if (dataMode.equals("data_mode_application")) {
                        arguments.put("wasmetha", new Object[]{((WASTranDelayRowModel)rowModel2).getMethodName()});
                        arguments.put("wasclssa", new Object[]{((WASTranDelayRowModel)rowModel2).getClassName()});
                        arguments.put("waslinea", new Object[]{((WASTranDelayRowModel)rowModel2).getLine()});
                        currentContext.setWASMethodNameKey("wasmetha");
                        currentContext.setWASClassNameKey("wasclssa");
                        currentContext.setLineNumberKey("waslinea");
                    } else if (dataMode.equals("data_mode_current")) {
                        arguments.put("wasmethc", new Object[]{((WASTranDelayRowModel)rowModel2).getMethodName()});
                        arguments.put("wasclssc", new Object[]{((WASTranDelayRowModel)rowModel2).getClassName()});
                        arguments.put("waslinec", new Object[]{((WASTranDelayRowModel)rowModel2).getLine()});
                        currentContext.setWASMethodNameKey("wasmethc");
                        currentContext.setWASClassNameKey("wasclssc");
                        currentContext.setLineNumberKey("waslinec");
                    } else if (dataMode.equals("data_mode_via")) {
                        arguments.put("wasmethv", new Object[]{((WASTranDelayRowModel)rowModel2).getMethodName()});
                        arguments.put("wasclssv", new Object[]{((WASTranDelayRowModel)rowModel2).getClassName()});
                        arguments.put("waslinev", new Object[]{((WASTranDelayRowModel)rowModel2).getLine()});
                        currentContext.setWASMethodNameKey("wasmethv");
                        currentContext.setWASClassNameKey("wasclssv");
                        currentContext.setLineNumberKey("waslinev");
                    } else {
                        String format = "%1$s: command(%2$s), row dataMode(%3$s) - INVALID COMBINATION";
                        throw new RuntimeException(String.format(format, ((Object)((Object)this)).getClass().toString(), commandId, ((WASTranDelayRowModel)rowModel2).getDataMode()));
                    }
                    currentContext.setDataMode(dataMode);
                    currentContext.setWASMethodNameTranslated(((WASTranDelayRowModel)rowModel2).getMethodNameTranslated());
                    currentContext.setWASMethodNameId(((WASTranDelayRowModel)rowModel2).getMethodName());
                    currentContext.setWASClassNameTranslated(((WASTranDelayRowModel)rowModel2).getClassNameTranslated());
                    currentContext.setWASClassNameId(((WASTranDelayRowModel)rowModel2).getClassName());
                    currentContext.setLineNumber(((WASTranDelayRowModel)rowModel2).getLine());
                }
            }
            MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, section, type);
            model = model.filterBy(arguments);
            model = AnalysisUtils.aggregateWAS(model, aggregateMode, dataMode, displayMode, dsn);
            IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(WASDelaysSubpage.class, section, dsn, type, presentation, "com.ca.mat.help.wasdelays", model, true);
            detachedView.setPresentationName("Java Delays");
            ((AbstractWASSubpage)detachedView.getCurrentPage()).setContextRestrictions(currentContext);
            ((AbstractWASSubpage)detachedView.getCurrentPage()).refreshHeader();
            Singletons.getAnalysisManager().analysisPageFocused(detachedView.getCurrentPage());
            return null;
        }
        if (obj instanceof WASViewRowModel) {
            rowModel = (WASViewRowModel)obj;
            if ((commandId.equals("com.ca.mat.commands.analysis.wasapp") || commandId.equals("com.ca.mat.commands.analysis.wascurrent") || commandId.equals("com.ca.mat.commands.analysis.wasvia")) && (page instanceof WASViewPage || page instanceof WASTransSubpage)) {
                this.processWASClassCommand(currentContext, page, commandId, ((WASViewRowModel)rowModel).getURLName(), ((WASViewRowModel)rowModel).getURLNameTranslated(), dsn, type);
                return null;
            }
            if (commandId.equals("com.ca.mat.commands.analysis.wassqldetails")) {
                currentContext = new WASViewPage.WASContextRestrictions();
                String section = "WAS Tran Delay";
                MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, section, type);
                HashMap<String, Object> arguments = new HashMap<String, Object[]>();
                arguments.put("tranurl", new Object[]{((WASViewRowModel)rowModel).getURLName()});
                model = model.filterBy(arguments);
                String[] SQLs = AnalysisUtils.getSQLsFromWasTran(model);
                section = "WAS SQL";
                model = Singletons.getAnalysisManager().getModel(dsn, section, type);
                arguments = new HashMap();
                arguments.put("transql", SQLs);
                currentContext.setFrom("URL");
                currentContext.setWASTransaction(((WASViewRowModel)rowModel).getURLName());
                currentContext.setWASTransactionTranslated(((WASViewRowModel)rowModel).getURLNameTranslated());
                if (model != null) {
                    model = model.filterBy(arguments, true);
                }
                if (model != null) {
                    IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(WASSQLSubpage.class, section, dsn, type, presentation, "com.ca.mat.help.wassqldetails", model, true);
                    detachedView.setPresentationName(String.format("Java SQL Details: %s", ((WASViewRowModel)rowModel).getURLNameTranslated()));
                    ((AbstractWASSubpage)detachedView.getCurrentPage()).setContextRestrictions(currentContext);
                    ((AbstractWASSubpage)detachedView.getCurrentPage()).refreshHeader();
                    Singletons.getAnalysisManager().analysisPageFocused(detachedView.getCurrentPage());
                }
                return null;
            }
        } else if (obj instanceof WASSQLRowModel) {
            rowModel = (WASSQLRowModel)obj;
            if (commandId.equals("com.ca.mat.commands.analysis.wastrans")) {
                currentContext = new WASViewPage.WASContextRestrictions();
                String section = "WAS Tran Delay";
                MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, section, type);
                HashMap<String, Object[]> arguments = new HashMap<String, Object[]>();
                arguments.put("tranurl", new Object[]{((WASSQLRowModel)rowModel).getTranURL()});
                arguments.put("transql", new Object[]{((WASSQLRowModel)rowModel).getTranSql()});
                if (model != null) {
                    model = model.filterBy(arguments);
                }
                if ((model = AnalysisUtils.aggregateWAS(model, "group_by_tran", "data_mode_application", "display_mode_tran", dsn)) != null) {
                    IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(WASTransSubpage.class, section, dsn, type, presentation, "com.ca.mat.help.wastrans", model, true);
                    detachedView.setPresentationName("Java Transaction Details");
                    currentContext.setSqlStatement(((WASSQLRowModel)rowModel).getSqlString(0));
                    ((AbstractWASSubpage)detachedView.getCurrentPage()).setContextRestrictions(currentContext);
                    ((AbstractWASSubpage)detachedView.getCurrentPage()).refreshHeader();
                    Singletons.getAnalysisManager().analysisPageFocused(detachedView.getCurrentPage());
                }
                return null;
            }
            if (commandId.equals("com.ca.mat.commands.analysis.wasdisplaysql")) {
                String location2 = "";
                MATTableModel model = new MATTableModel(dsn);
                model.addRow(rowModel);
                if (page instanceof AbstractWASSubpage) {
                    currentContext = ((AbstractWASSubpage)page).getContextRestrictions();
                }
                IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(WASSQLDisplaySubpage.class, location2, dsn, type, presentation, "com.ca.mat.help.selectsql", model, true);
                detachedView.setPresentationName("SQL Statement");
                ((WASSQLDisplaySubpage)detachedView.getCurrentPage()).setContextRestrictions(currentContext);
                Singletons.getAnalysisManager().analysisPageFocused(detachedView.getCurrentPage());
                return null;
            }
        } else if (obj instanceof WASTranDelayRowModel) {
            WASTranDelayRowModel row = (WASTranDelayRowModel)obj;
            if (commandId.equals("com.ca.mat.commands.analysis.wassqldetails")) {
                String wasMethodKey;
                String wasClassKey;
                String wasLnKey;
                String tranShrt = null;
                String dataMode = null;
                if (page instanceof AbstractWASSubpage) {
                    currentContext = ((AbstractWASSubpage)page).getContextRestrictions();
                    tranShrt = currentContext.getWASTransaction();
                    dataMode = currentContext.getDataMode();
                } else if (page instanceof WASViewPage) {
                    currentContext = new WASViewPage.WASContextRestrictions();
                    dataMode = row.getDataMode();
                    currentContext.setDataMode(dataMode);
                }
                String section = "WAS Tran Delay";
                if (dataMode.equals("data_mode_application")) {
                    wasLnKey = "waslinea";
                    wasClassKey = "wasclssa";
                    wasMethodKey = "wasmetha";
                } else if (dataMode.equals("data_mode_via")) {
                    wasLnKey = "waslinev";
                    wasClassKey = "wasclssv";
                    wasMethodKey = "wasmethv";
                } else if (dataMode.equals("data_mode_current")) {
                    wasLnKey = "waslinec";
                    wasClassKey = "wasclssc";
                    wasMethodKey = "wasmethc";
                } else {
                    return null;
                }
                HashMap<String, Object[]> arguments = new HashMap<String, Object[]>();
                if (tranShrt != null) {
                    arguments.put("tranurl", new Object[]{tranShrt});
                }
                arguments.put(wasMethodKey, new Object[]{row.getMethodName()});
                arguments.put(wasClassKey, new Object[]{row.getClassName()});
                arguments.put(wasLnKey, new Object[]{row.getLine()});
                currentContext.setLineNumberKey(wasLnKey);
                currentContext.setLineNumber(row.getLine());
                currentContext.setWASClassNameKey(wasClassKey);
                currentContext.setWASClassNameId(row.getClassName());
                currentContext.setWASClassNameTranslated(row.getClassNameTranslated());
                currentContext.setWASMethodNameKey(wasMethodKey);
                currentContext.setWASMethodNameId(row.getMethodName());
                currentContext.setWASMethodNameTranslated(row.getMethodNameTranslated());
                MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, section, type);
                model = model.filterBy(arguments);
                if (model == null) {
                    return null;
                }
                ArrayList<String> sqlKeysList = new ArrayList<String>();
                MATTableRow[] mATTableRowArray = model.getRows();
                int n = mATTableRowArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MATTableRow stepOneRow = mATTableRowArray[n2];
                    WASTranDelayRowModel r = (WASTranDelayRowModel)stepOneRow;
                    String sqlShort = r.getSqlshort();
                    if (sqlShort != null && (!sqlShort.equals("") || sqlKeysList.contains(sqlShort))) {
                        sqlKeysList.add(r.getSqlshort());
                    }
                    ++n2;
                }
                section = "WAS SQL";
                HashMap<String, Object[]> arguments_sql = new HashMap<String, Object[]>();
                arguments_sql.put("transql", sqlKeysList.toArray());
                model = Singletons.getAnalysisManager().getModel(dsn, section, type);
                if (model != null) {
                    if (tranShrt != null) {
                        HashMap<String, Object[]> arguments_url = new HashMap<String, Object[]>();
                        arguments_url.put("tranurl", new Object[]{tranShrt});
                        model = model.filterBy(arguments_url);
                    }
                    if (model != null) {
                        model = model.filterBy(arguments_sql, true, false);
                    }
                }
                if (model != null) {
                    IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(WASSQLSubpage.class, section, dsn, type, presentation, "com.ca.mat.help.wassqldetails", model, true);
                    ((AbstractWASSubpage)detachedView.getCurrentPage()).setContextRestrictions(currentContext);
                    ((AbstractWASSubpage)detachedView.getCurrentPage()).refreshHeader();
                    detachedView.setPresentationName("Java SQL Details");
                    Singletons.getAnalysisManager().analysisPageFocused(detachedView.getCurrentPage());
                }
                return null;
            }
            if (commandId.equals("com.ca.mat.commands.analysis.wasapp") || commandId.equals("com.ca.mat.commands.analysis.wascurrent") || commandId.equals("com.ca.mat.commands.analysis.wasvia")) {
                this.processWASClassCommand(currentContext, page, commandId, row.getTran(), row.getTranTranslated(), dsn, type);
                return null;
            }
        }
        if (commandId.equals("com.ca.mat.commands.analysis.wasenvironment")) {
            location = "WAS Environment Report";
            MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, location, type);
            IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(TextDisplaySubpage.class, location, dsn, type, presentation, "com.ca.mat.help.wasenvironment", model);
            detachedView.setPresentationName("Java Environment");
            return null;
        }
        if (commandId.equals("com.ca.mat.commands.analysis.wasgarbage")) {
            location = "WAS Garbage Collection";
            MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, location, type);
            IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(TextDisplaySubpage.class, location, dsn, type, presentation, "com.ca.mat.help.wasgarbage", model);
            detachedView.setPresentationName("Java Garbage Collection");
            return null;
        }
        if (commandId.equals("com.ca.mat.commands.analysis.wassql")) {
            String section = "WAS SQL";
            currentContext = new WASViewPage.WASContextRestrictions();
            MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, section, type);
            IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(WASSQLSubpage.class, section, dsn, type, presentation, "com.ca.mat.help.wassqlstatements", model);
            detachedView.setPresentationName("Java SQL Statements");
            ((AbstractWASSubpage)detachedView.getCurrentPage()).setContextRestrictions(currentContext);
            return null;
        }
        if (commandId.startsWith("com.ca.mat.commands.analysis.mode.")) {
            boolean compare;
            WASViewPage oldPage = (WASViewPage)presentation.getActivePage();
            PageWithModesContainer newPageContainer = oldPage.changeMode(commandId);
            if (newPageContainer.getModel() != null) {
                AnalysisTabbedView tabView;
                presentation.addPage(newPageContainer.getAnalysisPage(), true);
                ((WASViewPage)newPageContainer.getAnalysisPage()).setModel(newPageContainer.getModel());
                presentation.showPage(newPageContainer.getAnalysisPage());
                Singletons.getAnalysisManager().analysisPageFocused(newPageContainer.getAnalysisPage());
                if (presentation instanceof AnalysisTabbedView && !oldPage.equals((tabView = (AnalysisTabbedView)presentation).getPage("Java"))) {
                    oldPage.dispose();
                }
            }
            if (commandId.equals("com.ca.mat.commands.analysis.mode.wasview.url")) {
                boolean compare2 = Singletons.getCompareManager().getCompare();
                if (compare2) {
                    Singletons.getCompareManager().modeChanged(commandId);
                }
            } else if (commandId.equals("com.ca.mat.commands.analysis.mode.wasview.application")) {
                boolean compare3 = Singletons.getCompareManager().getCompare();
                if (compare3) {
                    new HashMap();
                    Singletons.getCompareManager().modeChanged(commandId);
                }
            } else if (commandId.equals("com.ca.mat.commands.analysis.mode.wasview.via")) {
                boolean compare4 = Singletons.getCompareManager().getCompare();
                if (compare4) {
                    Singletons.getCompareManager().modeChanged(commandId);
                }
            } else if (commandId.equals("com.ca.mat.commands.analysis.mode.wasview.current") && (compare = Singletons.getCompareManager().getCompare())) {
                Singletons.getCompareManager().modeChanged(commandId);
            }
        }
        return null;
    }

    private void processWASClassCommand(WASViewPage.WASContextRestrictions currentContext, AnalysisPage page, String commandId, String transaction, String transactionTranslated, String dsn, int type) {
        String section = "WAS Tran Delay";
        String aggregateMode = "group_by_class_method_line";
        String dataMode = null;
        String title = null;
        String displayMode = "display_mode_class";
        String contextHelpId = "";
        String from = null;
        IAnalysisPagePresentation presentation = page.getPresentation();
        if (page instanceof AbstractWASSubpage) {
            currentContext = ((AbstractWASSubpage)page).getContextRestrictions();
        }
        if (currentContext == null) {
            currentContext = new WASViewPage.WASContextRestrictions();
        }
        if (page instanceof WASViewPage) {
            from = "URL";
            currentContext.setFrom(from);
        }
        if (commandId.equals("com.ca.mat.commands.analysis.wasapp")) {
            dataMode = "data_mode_application";
            title = "Java Application Classes";
            contextHelpId = "com.ca.mat.help.wasapp";
        } else if (commandId.equals("com.ca.mat.commands.analysis.wascurrent")) {
            dataMode = "data_mode_current";
            title = "Java Current Classes";
            contextHelpId = "com.ca.mat.help.wascurrent";
        } else if (commandId.equals("com.ca.mat.commands.analysis.wasvia")) {
            dataMode = "data_mode_via";
            title = "Java Via Classes";
            contextHelpId = "com.ca.mat.help.wasvia";
        } else {
            throw new RuntimeException(String.format("invalid command encountered (%s)", commandId));
        }
        HashMap<String, Object[]> arguments = new HashMap<String, Object[]>();
        arguments.put("tranurl", new Object[]{transaction});
        currentContext.setDataMode(dataMode);
        currentContext.setWASTransaction(transaction);
        currentContext.setWASTransactionTranslated(transactionTranslated);
        MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, section, type);
        model = model.filterBy(arguments);
        model = AnalysisUtils.aggregateWAS(model, aggregateMode, dataMode, displayMode, dsn);
        IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(WASClassSubpage.class, section, dsn, type, presentation, contextHelpId, model, true);
        detachedView.setPresentationName(title);
        ((AbstractWASSubpage)detachedView.getCurrentPage()).setContextRestrictions(currentContext);
        ((AbstractWASSubpage)detachedView.getCurrentPage()).refreshHeader();
        Singletons.getAnalysisManager().analysisPageFocused(detachedView.getCurrentPage());
    }
}

