/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.views.pages;

import com.ca.mat.common.table.IMATTableViewer;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.managers.Singletons;
import com.ca.mat.views.pages.AnalysisPageBasic;

public class CodeView4GLPage
extends AnalysisPageBasic {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    public static final String ID = "com.ca.mat.pages.codeview4gl";
    public static final String CONTEXT_HELP_ID_IDEAL = "com.ca.mat.help.ideal";
    public static final String CONTEXT_HELP_ID_NATURAL = "com.ca.mat.help.natural";
    public static final String VIEWER_MEMENTO_TYPE_IDEAL = "pages.codeview4gl.viewer_ideal";
    public static final String VIEWER_MEMENTO_TYPE_NATURAL = "pages.codeview4gl.viewer_natural";
    private static final String AUTONAV_COMMAND_ID = "com.ca.mat.commands.analysis.codeview4gl.histogram";
    public static final String SECTION_NAME = "CodeView Mode-4GL";
    public static final String TTASKID = "ttaskid";
    private String language;

    @Override
    protected void setUpViewer(IMATTableViewer viewer) {
        if (this.language == null) {
            throw new IllegalStateException("Language not set for CodeView4GL page");
        }
        if (this.language.equals("NAT")) {
            viewer.addColumn("Language", 5, "Language", 1, true, false);
            viewer.addColumn("Library", 5, "Library", 1, true, false);
            viewer.addColumn("Routine", 5, "Routine", 1, true, false);
            viewer.addColumn("Active %", 4, "Active%", 9, true, true);
            viewer.addColumn("Wait %", 4, "Wait%", 9, true, true);
            viewer.addColumn("Total %", 4, "Total%", 9, true, true);
            viewer.addColumn("Routine Description", 7, " Routine Description", 1, true, true);
            viewer.setDefaultSortColumn(5);
            viewer.setDefaultSortDirection(128);
        }
        if (this.language.equals("IDEAL")) {
            viewer.addColumn("Language", 5, "Language", 1, true, false);
            viewer.addColumn("System", 5, "Library", 1, true, false);
            viewer.addColumn("Program", 5, "Routine", 1, true, false);
            viewer.addColumn("Obj pgm version", 5, "Object Program Version", 1, true, true);
            viewer.addColumn("Src pgm version", 5, "Source Program Version", 1, true, true);
            viewer.addColumn("Actv%", 4, "Actv%", 9, true, true);
            viewer.addColumn("Wait%", 4, "Wait%", 9, true, true);
            viewer.addColumn("Totl%", 4, "Totl%", 9, true, true);
            viewer.addColumn("Routine Description", 7, " Routine Description", 1, true, true);
            viewer.setDefaultSortColumn(7);
            viewer.setDefaultSortDirection(128);
        }
        MATTableModel model = Singletons.getAnalysisManager().getModel(this.dsn, SECTION_NAME, this.type);
        String langString = "";
        if (this.language == "NAT") {
            langString = "NATURAL";
        }
        if (this.language == "IDEAL") {
            langString = "IDEAL";
        }
        model = model.filterBy("xlang", langString);
        this.setModel(model);
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    @Override
    public void setType(int type) {
        super.setType(type);
        MATTableModel model = Singletons.getAnalysisManager().getModel(this.dsn, SECTION_NAME, type);
        String langString = "";
        if (this.language == "NAT") {
            langString = "NATURAL";
        }
        if (this.language == "IDEAL") {
            langString = "IDEAL";
        }
        if (model != null) {
            model = model.filterBy("xlang", langString);
        }
        this.setModel(model);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getContextHelpId() {
        if (this.language == "NAT") {
            return CONTEXT_HELP_ID_NATURAL;
        }
        if (this.language == "IDEAL") {
            return CONTEXT_HELP_ID_IDEAL;
        }
        return null;
    }

    @Override
    protected String getViewerMementoType() {
        if (this.language == "NAT") {
            return VIEWER_MEMENTO_TYPE_NATURAL;
        }
        if (this.language == "IDEAL") {
            return VIEWER_MEMENTO_TYPE_IDEAL;
        }
        return null;
    }

    @Override
    protected String getAutonavigationCommandId() {
        return AUTONAV_COMMAND_ID;
    }
}

