/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.views.pages;

import com.ca.mat.common.table.IMATTableViewer;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.managers.AnalysisManager;
import com.ca.mat.managers.AnalysisUtils;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.IDMSReportRowModel;
import com.ca.mat.rowmodels.IDMSViewRowModel;
import com.ca.mat.views.pages.AnalysisPageBasic;
import com.ca.mat.views.pages.IPageWithModes;
import com.ca.mat.views.pages.PageWithModesContainer;
import java.util.HashMap;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class IDMSPage
extends AnalysisPageBasic
implements IPageWithModes {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    public static final String ID_MODULE = "com.ca.mat.pages.idms.modulemode";
    public static final String ID_TASK = "com.ca.mat.pages.idms.taskmode";
    public static final String SECTION_NAME = "IDMS Delays";
    private static final String VIEWER_MEMENTO_TYPE_MODULE = "pages.idms.viewer.module";
    private static final String VIEWER_MEMENTO_TYPE_TASK = "pages.idms.viewer.task";
    public static final String CONTEXT_HELP_ID = "com.ca.mat.help.idmsview";
    private static final String HEADER_SECTION_NAME = "IDMS Global Information";
    private static final String ID_ROOT = "com.ca.mat.pages.idms";
    static final String AUTONAV_COMMAND_ID = "com.ca.mat.commands.analysis.idmsview.idmsdmldelays";
    private String modeType = IDMSViewRowModel.TYPE_MODULE;
    private HashMap<String, String> filterExpressions = new HashMap();
    private String currentMode = IDMSViewRowModel.TYPE_MODULE;
    private Label titleLabel;

    @Override
    protected void setUpViewer(IMATTableViewer viewer) {
        if (this.modeType.equals(IDMSViewRowModel.TYPE_MODULE)) {
            viewer.addColumn("TaskCode", 5, "TaskCode", 1);
            viewer.addColumn("Module", 5, "Module", 1);
            viewer.addColumn("Offset", 5, "Offset", 1);
            viewer.addColumn("Status", 7, "Status", 1);
            viewer.addColumn("Total %", 5, "Total %", 3);
            viewer.addColumn("Wait", 7, "Wait", 1);
            viewer.setSecondarySortColumn(4, 2);
            viewer.setSecondarySortDirection(4, 128);
            viewer.setSortColumn(4);
            viewer.setSortDirection(1024);
        } else if (this.modeType.equals(IDMSViewRowModel.TYPE_TASK)) {
            viewer.addColumn("TaskCode", 5, "TaskCode", 1);
            viewer.addColumn("Total %", 5, "Total %", 3);
            viewer.setDefaultSortColumn(1);
        }
    }

    @Override
    public void setType(int type) {
        super.setType(type);
        MATTableModel model = Singletons.getAnalysisManager().getModel(this.dsn, SECTION_NAME, type);
        if (this.modeType.equals(IDMSViewRowModel.TYPE_TASK)) {
            model = AnalysisUtils.changeIDMSModel(model, this.modeType, this.getDSN());
        }
        this.setModel(model);
    }

    @Override
    protected String getViewerMementoType() {
        if (this.modeType.equals(IDMSViewRowModel.TYPE_MODULE)) {
            return VIEWER_MEMENTO_TYPE_MODULE;
        }
        if (this.modeType.equals(IDMSViewRowModel.TYPE_TASK)) {
            return VIEWER_MEMENTO_TYPE_TASK;
        }
        return null;
    }

    @Override
    public String getContextHelpId() {
        return CONTEXT_HELP_ID;
    }

    @Override
    public String getId() {
        if (this.modeType.equals(IDMSViewRowModel.TYPE_MODULE)) {
            return ID_MODULE;
        }
        if (this.modeType.equals(IDMSViewRowModel.TYPE_TASK)) {
            return ID_TASK;
        }
        return null;
    }

    @Override
    public void createHeaderPart(Composite parent) {
        Composite wrapper = new Composite(parent, 0);
        wrapper.setLayout((Layout)new RowLayout());
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        wrapper.setLayoutData((Object)gridData);
        Composite group1 = new Composite(wrapper, 0);
        group1.setLayout((Layout)new GridLayout(6, false));
        this.titleLabel = new Label(wrapper, 16384);
        this.titleLabel.setText("CV Number: N/A   IDMS Release: N/A    Local Mode: N/A                      ");
        AnalysisManager manager = Singletons.getAnalysisManager();
        MATTableModel model = manager.getModel(this.dsn, HEADER_SECTION_NAME, this.type);
        this.setHeaderModel(model);
    }

    public void setModeType(String modeType) {
        this.modeType = modeType;
    }

    public String getModeType() {
        return this.modeType;
    }

    public String getModelLocation() {
        return SECTION_NAME;
    }

    private void setFilterValue(String key, String expression) {
        this.filterExpressions.put(key, expression);
    }

    public HashMap<String, String> getFilterExpressions() {
        return this.filterExpressions;
    }

    public void setFilterExpressions(HashMap<String, String> newFilters) {
        this.filterExpressions = newFilters;
    }

    @Override
    public String getAdditionalTitleText() {
        return "Mode: " + this.modeType;
    }

    private void setHeaderModel(MATTableModel model) {
        if (model != null && !model.isEmpty() && model.getRows()[0] instanceof IDMSReportRowModel) {
            IDMSReportRowModel row = (IDMSReportRowModel)model.getRows()[0];
            this.titleLabel.setText("CV Number: " + row.getCVNumber() + " IDMS Release: " + row.getIDMSLevel() + " Local Mode: " + row.getLocalMode());
        }
    }

    @Override
    public String getRootId() {
        return ID_ROOT;
    }

    @Override
    public PageWithModesContainer changeMode(String newMode) {
        HashMap<String, String> activeInternalFilters = this.getFilterExpressions();
        HashMap newFilters = (HashMap)activeInternalFilters.clone();
        MATTableModel nextModel = Singletons.getAnalysisManager().getModel(this.dsn, this.getModelLocation(), this.type);
        if (!newFilters.keySet().isEmpty()) {
            for (String key : newFilters.keySet()) {
                nextModel = nextModel.filterBy(key, newFilters.get(key));
            }
        }
        if (newMode.equals(IDMSViewRowModel.TYPE_TASK)) {
            nextModel = AnalysisUtils.changeIDMSModel(nextModel, newMode, this.dsn);
        }
        IDMSPage page = new IDMSPage();
        page.setDSN(this.dsn);
        page.setType(this.type);
        page.setModeType(newMode);
        page.setFilterExpressions(newFilters);
        page.currentMode = newMode;
        return new PageWithModesContainer(page, nextModel);
    }

    @Override
    public String getCurrentMode() {
        return this.currentMode;
    }

    @Override
    protected String getAutonavigationCommandId() {
        return AUTONAV_COMMAND_ID;
    }
}

