/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.views.pages;

import com.ca.mat.MATException;
import com.ca.mat.common.table.IMATTableViewer;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableRow;
import com.ca.mat.managers.AnalysisManager;
import com.ca.mat.managers.AnalysisUtils;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.WASTranDelayRowModel;
import com.ca.mat.rowmodels.WASViewRowModel;
import com.ca.mat.views.pages.AnalysisPageBasic;
import com.ca.mat.views.pages.IPageWithModes;
import com.ca.mat.views.pages.PageWithModesContainer;
import java.util.HashMap;

public class WASViewPage
extends AnalysisPageBasic
implements IPageWithModes {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    private static final String ID_ROOT = "com.ca.mat.pages.was";
    public static final String ID_URL = "com.ca.mat.pages.was.url";
    public static final String ID_APPLICATION = "com.ca.mat.pages.was.application";
    public static final String ID_CURRENT = "com.ca.mat.pages.was.current";
    public static final String ID_VIA = "com.ca.mat.pages.was.via";
    public static final String SECTION_NAME = "WAS Tran Stats";
    public static final String DELAY_SECTION_NAME = "WAS Tran Delay";
    public static final String CONTEXT_HELP_ID = "com.ca.mat.help.was";
    static final String AUTONAV_COMMAND_ID = "com.ca.mat.commands.analysis.wasdelays";
    public static final String DELAY_COMMAND = "com.ca.mat.commands.analysis.wasdelays";
    public static final String APP_CLASSES_COMMAND = "com.ca.mat.commands.analysis.wasapp";
    public static final String DISPLAY_MODE_URL = "display_mode_url";
    public static final String DISPLAY_MODE_APP = "display_mode_appl";
    public static final String DISPLAY_MODE_CUR = "display_mode_curr";
    public static final String DISPLAY_MODE_VIA = "display_mode_via";
    private String modeType = "display_mode_url";
    private String modeSubtype;
    private String modelLocation;
    private boolean percentPop = false;
    private MATTableModel delayModel;
    private String modeAggregate;
    private String displaySuperMode;
    private String currentMode = "com.ca.mat.commands.analysis.mode.wasview.url";

    @Override
    protected void setUpViewer(IMATTableViewer viewer) {
        if (this.modeType.equals(DISPLAY_MODE_URL)) {
            AnalysisManager manager = Singletons.getAnalysisManager();
            MATTableModel model = manager.getModel(this.dsn, SECTION_NAME, this.type);
            this.delayModel = manager.getModel(this.dsn, DELAY_SECTION_NAME, this.type);
            viewer.addColumn("Transaction / URL", 9, null, 1, true, false);
            viewer.addColumn("Active%", 5, null, 3);
            viewer.addColumn("InvWait%", 5, null, 3);
            viewer.addColumn("VolWait%", 5, null, 3);
            viewer.addColumn("Total%", 5, null, 3);
            viewer.addColumn("Total Count", 5, null, 2);
            viewer.addColumn("Total Resp", 5, null, 3, false, true);
            viewer.addColumn("Avg Resp", 5, null, 3);
            viewer.addColumn("Max Resp", 5, null, 3);
            viewer.addColumn("Min Resp", 5, null, 3);
            viewer.setSortColumn(4);
            viewer.setSortDirection(1024);
            viewer.setDefaultSortColumn(4);
            if (model == null) {
                return;
            }
            if (this.delayModel == null) {
                viewer.setColumnEmpty(1);
                viewer.setColumnEmpty(2);
                viewer.setColumnEmpty(3);
                viewer.setColumnEmpty(4);
                viewer.setDefaultSortColumn(6);
            } else {
                if (!this.percentPop) {
                    this.populatePercentages(model, this.delayModel);
                }
                this.percentPop = true;
            }
        } else {
            viewer.addColumn("Class Name", 7, "Class Name", 1);
            viewer.addColumn("Method Name", 7, "Method Name", 1);
            viewer.addColumn("Line #", 5, "Line #", 1);
            viewer.addColumn("Active %", 4, "Active %", 9);
            viewer.addColumn("InvWait %", 4, "InvWait %", 9);
            viewer.addColumn("VolWait %", 4, "VolWait %", 9);
            viewer.addColumn("Total %", 4, "Total %", 9);
            viewer.setDefaultSortColumn(6);
            viewer.setDefaultSortDirection(1024);
        }
        viewer.addDoubleClickListener(this);
    }

    @Override
    public String getId() {
        if (DISPLAY_MODE_URL.equals(this.modeType)) {
            return ID_URL;
        }
        if (DISPLAY_MODE_APP.equals(this.modeType)) {
            return ID_APPLICATION;
        }
        if (DISPLAY_MODE_CUR.equals(this.modeType)) {
            return ID_CURRENT;
        }
        if (DISPLAY_MODE_VIA.equals(this.modeType)) {
            return ID_VIA;
        }
        throw new MATException("Invalid WASView mode: " + this.modeType);
    }

    @Override
    public void setType(int type) {
        MATTableModel model;
        super.setType(type);
        if (this.currentMode.equals("com.ca.mat.commands.analysis.mode.wasview.url")) {
            String location = SECTION_NAME;
            this.modeAggregate = null;
            model = Singletons.getAnalysisManager().getModel(this.dsn, location, type);
            this.delayModel = Singletons.getAnalysisManager().getModel(this.dsn, DELAY_SECTION_NAME, type);
            if (this.delayModel != null) {
                this.populatePercentages(model, this.delayModel);
            }
        } else {
            String location = DELAY_SECTION_NAME;
            model = Singletons.getAnalysisManager().getModel(this.dsn, location, type);
        }
        if (this.modeAggregate != null) {
            model = AnalysisUtils.aggregateWAS(model, this.modeAggregate, this.modeSubtype, this.displaySuperMode, this.dsn);
        }
        this.setModel(model);
    }

    public String getModelLocation() {
        return this.modelLocation;
    }

    public void setModelLocation(String modelLocation) {
        this.modelLocation = modelLocation;
    }

    @Override
    protected String getViewerMementoType() {
        String VIEWER_MEMENTO_TYPE = null;
        if (this.modeType.equals(DISPLAY_MODE_URL)) {
            VIEWER_MEMENTO_TYPE = "pages.was.url.viewer";
        } else if (this.modeType.equals(DISPLAY_MODE_APP)) {
            VIEWER_MEMENTO_TYPE = "pages.was.application.viewer";
        } else if (this.modeType.equals(DISPLAY_MODE_CUR)) {
            VIEWER_MEMENTO_TYPE = "pages.was.current.viewer";
        } else if (this.modeType.equals(DISPLAY_MODE_VIA)) {
            VIEWER_MEMENTO_TYPE = "pages.was.via.viewer";
        }
        return VIEWER_MEMENTO_TYPE;
    }

    @Override
    protected String getAutonavigationCommandId() {
        return "com.ca.mat.commands.analysis.wasdelays";
    }

    @Override
    public String getContextHelpId() {
        return CONTEXT_HELP_ID;
    }

    @Override
    public String getAdditionalTitleText() {
        this.delayModel = Singletons.getAnalysisManager().getModel(this.dsn, DELAY_SECTION_NAME, this.type);
        if (this.delayModel == null) {
            return "Transaction Only Mode";
        }
        String modeString = this.modeType.equals(DISPLAY_MODE_APP) ? "Application" : (this.modeType.equals(DISPLAY_MODE_CUR) ? "Current" : (this.modeType.equals(DISPLAY_MODE_VIA) ? "Via" : (this.modeType.equals(DISPLAY_MODE_URL) ? "URL" : "Unknown")));
        return "Mode: " + modeString;
    }

    public String getModeType() {
        return this.modeType;
    }

    public void setModeType(String modeType) {
        this.modeType = modeType;
    }

    @Override
    public void setModel(MATTableModel model) {
        this.percentPop = false;
        super.setModel(model);
    }

    public String getModeSubtype() {
        return this.modeSubtype;
    }

    public void setModeSubtype(String modeSubtype) {
        this.modeSubtype = modeSubtype;
    }

    private void populatePercentages(MATTableModel tran, MATTableModel delay) {
        MATTableRow row;
        HashMap<String, WASTranDelayRowModel> resultRows = new HashMap<String, WASTranDelayRowModel>();
        MATTableRow[] mATTableRowArray = delay.getRows();
        int n = mATTableRowArray.length;
        int n2 = 0;
        while (n2 < n) {
            row = mATTableRowArray[n2];
            WASTranDelayRowModel wasRow = (WASTranDelayRowModel)row;
            String key = "";
            wasRow.setDataMode("data_mode_application");
            key = wasRow.getTran();
            if (resultRows.get(key) == null) {
                WASTranDelayRowModel clone = wasRow.clone();
                clone.setDataMode("data_mode_application");
                resultRows.put(key, clone);
            } else {
                ((WASTranDelayRowModel)resultRows.get(key)).addRow(wasRow);
            }
            ++n2;
        }
        mATTableRowArray = tran.getRows();
        n = mATTableRowArray.length;
        n2 = 0;
        while (n2 < n) {
            row = mATTableRowArray[n2];
            WASViewRowModel tranRow = (WASViewRowModel)row;
            WASTranDelayRowModel delayRow = (WASTranDelayRowModel)resultRows.get(tranRow.getTranURL());
            if (delayRow != null) {
                tranRow.setExepct(delayRow.getExepct());
                tranRow.setInvpct(delayRow.getInvpct());
                tranRow.setTotpct(delayRow.getTotpct());
                tranRow.setVolpct(delayRow.getVolpct());
            }
            ++n2;
        }
    }

    public void setModeAggregate(String aggregateMode) {
        this.modeAggregate = aggregateMode;
    }

    public String getModeAggregate() {
        return this.modeAggregate;
    }

    public void setDisplayMode(String displayMode) {
        this.displaySuperMode = displayMode;
    }

    public String getDisplayMode() {
        return this.displaySuperMode;
    }

    @Override
    public PageWithModesContainer changeMode(String newMode) {
        WASViewPage newPage = new WASViewPage();
        String location = null;
        String dataMode = null;
        String aggregateMode = null;
        String displayMode = "display_mode_class";
        newPage.setDisplayMode(displayMode);
        newPage.setDSN(this.dsn);
        newPage.setType(this.type);
        if (newMode.equals("com.ca.mat.commands.analysis.mode.wasview.url")) {
            location = SECTION_NAME;
            newPage.setModeType(DISPLAY_MODE_URL);
            newPage.setModelLocation(location);
        } else if (newMode.equals("com.ca.mat.commands.analysis.mode.wasview.application")) {
            location = DELAY_SECTION_NAME;
            newPage.setModeType(DISPLAY_MODE_APP);
            newPage.setModelLocation(location);
            dataMode = "data_mode_application";
            aggregateMode = "group_by_class_method_line";
            newPage.setModeSubtype(dataMode);
            newPage.setModeAggregate(aggregateMode);
        } else if (newMode.equals("com.ca.mat.commands.analysis.mode.wasview.via")) {
            location = DELAY_SECTION_NAME;
            newPage.setModeType(DISPLAY_MODE_VIA);
            newPage.setModelLocation(location);
            dataMode = "data_mode_via";
            aggregateMode = "group_by_class_method_line";
            newPage.setModeSubtype(dataMode);
            newPage.setModeAggregate(aggregateMode);
        } else if (newMode.equals("com.ca.mat.commands.analysis.mode.wasview.current")) {
            location = DELAY_SECTION_NAME;
            newPage.setModeType(DISPLAY_MODE_CUR);
            newPage.setModelLocation(location);
            dataMode = "data_mode_current";
            aggregateMode = "group_by_class_method_line";
            newPage.setModeSubtype(dataMode);
            newPage.setModeAggregate(aggregateMode);
        }
        MATTableModel model = Singletons.getAnalysisManager().getModel(this.dsn, location, this.type);
        if (aggregateMode != null) {
            model = AnalysisUtils.aggregateWAS(model, aggregateMode, dataMode, displayMode, this.dsn);
        }
        newPage.setModel(model);
        newPage.currentMode = newMode;
        return new PageWithModesContainer(newPage, model);
    }

    @Override
    public String getRootId() {
        return ID_ROOT;
    }

    @Override
    public String getCurrentMode() {
        return this.currentMode;
    }

    public static class WASContextRestrictions
    implements Cloneable {
        private String methodName;
        private String className;
        private String transaction;
        private String lineNumber;
        private String transactionTranslated;
        private String methodNameTranslated;
        private String classNameTranslated;
        private String methodNameKey;
        private String classNameKey;
        private String lineNumberKey;
        private String dataMode;
        private String sqlStatement;
        private String from;

        public WASContextRestrictions clone() {
            WASContextRestrictions result = new WASContextRestrictions();
            result.methodName = this.methodName;
            result.className = this.className;
            result.classNameKey = this.classNameKey;
            result.classNameTranslated = this.classNameTranslated;
            result.lineNumber = this.lineNumber;
            result.methodName = this.methodName;
            result.methodNameKey = this.methodNameKey;
            result.methodNameTranslated = this.methodNameTranslated;
            result.transaction = this.transaction;
            result.transactionTranslated = this.transactionTranslated;
            result.dataMode = this.dataMode;
            result.sqlStatement = this.sqlStatement;
            result.from = this.from;
            return result;
        }

        public String getWASMethodNameId() {
            return this.methodName;
        }

        public void setWASMethodNameId(String methodName) {
            this.methodName = methodName;
        }

        public String getWASClassNameId() {
            return this.className;
        }

        public void setWASClassNameId(String className) {
            this.className = className;
        }

        public String getWASTransaction() {
            return this.transaction;
        }

        public void setWASTransaction(String transaction) {
            this.transaction = transaction;
        }

        public String getLineNumber() {
            return this.lineNumber;
        }

        public void setLineNumber(String lineNumber) {
            this.lineNumber = lineNumber;
        }

        public String getWASTransactionTranslated() {
            return this.transactionTranslated;
        }

        public void setWASTransactionTranslated(String transactionTranslated) {
            this.transactionTranslated = transactionTranslated;
        }

        public String getWASMethodNameTranslated() {
            return this.methodNameTranslated;
        }

        public void setWASMethodNameTranslated(String methodNameTranslated) {
            this.methodNameTranslated = methodNameTranslated;
        }

        public String getWASClassNameTranslated() {
            return this.classNameTranslated;
        }

        public void setWASClassNameTranslated(String classNameTranslated) {
            this.classNameTranslated = classNameTranslated;
        }

        public void setWASMethodNameKey(String methodNameKey) {
            this.methodNameKey = methodNameKey;
        }

        public String getWASMethodNameKey() {
            return this.methodNameKey;
        }

        public void setWASClassNameKey(String classNameKey) {
            this.classNameKey = classNameKey;
        }

        public String getWASClassNameKey() {
            return this.classNameKey;
        }

        public void setLineNumberKey(String lineNumberKey) {
            this.lineNumberKey = lineNumberKey;
        }

        public String getLineNumberKey() {
            return this.lineNumberKey;
        }

        public void setDataMode(String dataMode) {
            this.dataMode = dataMode;
        }

        public String getDataMode() {
            return this.dataMode;
        }

        public void setSqlStatement(String sqlStatement) {
            this.sqlStatement = sqlStatement;
        }

        public String getSqlStatement() {
            return this.sqlStatement;
        }

        public void setFrom(String from) {
            this.from = from;
        }

        public String getFrom() {
            return this.from;
        }
    }
}

