/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Author: Alexey Makhalov <amakhalov@vmware.com>
 */

#include "libinit.h"

#define try_run(x) \
    extern int x##_main(int argc, char **argv); \
    do { \
        if (!strcmp(base_name(argv[0]), #x)) { \
            we_are = #x; \
	    return x##_main(argc, argv); \
        } \
    } while (0)

int main(int argc, char **argv)
{
    try_run(checkproc);
    try_run(killproc);
    try_run(startproc);
    return 0;
}
