#!/bin/bash

check_image_type() {
   IMG_TARGET=image
   make -qp | awk -F':' '/^[a-zA-Z0-9][^$#\/\t=]*:([^=]|$)/ {split($1,A,/ /);for(i in A)print A[i]}' | grep cloud-image
   if [ $? -eq 0 ]; then
      IMG_TARGET=cloud-image
   fi
}

generic_full_config(){
   if [ ${IMG_TARGET} == "cloud-image" ]; then
      echo "###############################################################"
      echo "update build_install_options_ova_generic.json"
      echo "###############################################################"
      cat ${LOCAL_PATH}/build_install_options_ova_generic.json > stage/common/data/build_install_options_ova_generic.json
      cat ${LOCAL_PATH}/build_install_options_ova_generic.json > common/data/build_install_options_ova_generic.json
      echo "cat stage/common/data/build_install_options_ova_generic.json ... ..."
      cat stage/common/data/build_install_options_ova_generic.json
      echo "cat common/data/build_install_options_ova_generic.json ... ..."
      cat common/data/build_install_options_ova_generic.json
   else
      echo "###############################################################"
      echo "For generic full ova: create common/data/packages_full.json"
      echo "###############################################################"
      cp ${LOCAL_PATH}/packages_full.json common/data/packages_full.json
      if [ ! -z ${BRANCH} ] && [ ${BRANCH} == "dev" ];then
         echo "dev branch: remove python3-lvm2-libs and asciidoc from common/data/packages_full.json ... ..."
         sed -i '/python3-lvm2-libs/d' common/data/packages_full.json
         sed -i '/asciidoc/d' common/data/packages_full.json
      fi
   fi
   echo "cat common/data/packages_full.json ... ..."
   cat common/data/packages_full.json
}

generic_minimal_config(){
   echo "###############################################################"
   echo "For generic minimal ova: update common/data/packages_minimal.json"
   echo "###############################################################"
   sed '/minimal/ a "nfs-utils","tar","gawk",' common/data/packages_minimal.json > common/data/packages_minimal_new.json
   mv common/data/packages_minimal_new.json common/data/packages_minimal.json
   echo "cat common/data/packages_minimal.json ... ..."
   cat common/data/packages_minimal.json
}

generate_json() {
   origin_json=$1
   new_json=$2
   replace_json="packages_${FLAVOR}.json"
   echo replace_json=$replace_json
   touch ${new_json}
   echo "" >  ${new_json}
   while IFS= read -r line; do
      if [[ ${line} == *"packagelist_file"* ]]; then
         line=`sed "s/packages_ova.json/${replace_json}/g" <<< "${line}"`
      elif [[ $line == *"expirepassword"* ]]; then
         line=`sed "s/true/false/g" <<< "${line}"`
      elif [[ $line == *"age"* ]]; then
         # 'age' is in the config_ova.json for dev branch for now
         # which is replaced the function of 'expirepassword'
         line=`sed "s/0/-1/g" <<< "${line}"`
      elif [[ $line == *"linux_flavor"* ]]; then
         # to replace linux_flave with linux for generic ovas
         line=`sed 's/"linux_flavor" *: *".*"/"linux_flavor": "linux"/'  <<< "${line}"`
      fi
      echo $line >> ${new_json}
   done < "${origin_json}"
   mv ${new_json} support/image-builder/ova/

   echo "################################################################################"
   echo "cat support/image-builder/ova/${new_json}"
   echo "################################################################################"
   cat support/image-builder/ova/${new_json}
}

config_generic_ova() {
   # check current build method
   # 1.0 and 2.0: make ${IMG_TARGET} IMG_NAME=ova_generic ${BUILD_PARAMS}
   # others: make ${IMG_TARGET} CONFIG=support/image-builder/ova/config_ova_generic_${FLAVOR}.json ${BUILD_PARAMS}
   check_image_type

   if [ ${FLAVOR} == "full" ];then
      generic_full_config
   fi

   if [ ${FLAVOR} == "minimal" ];then
      generic_minimal_config
   fi

   # Build generic ${FLAVOR} ova.
   if [ ${IMG_TARGET} == "cloud-image" ]; then
      echo "#############################################################################"
      echo "update support/cloud-image-builder/ova_generic/ova_generic-custom-patch.sh"
      echo "#############################################################################"
      sed -i 's/chage/\#chage/g' support/cloud-image-builder/ova_generic/ova_generic-custom-patch.sh
      cat support/cloud-image-builder/ova_generic/ova_generic-custom-patch.sh
      echo "#############################################################################"
      echo "update support/cloud-image-builder/ova_generic/vmdk_ova_generic.json"
      echo "#############################################################################"
      sed -i 's/PASSWORD/changeme/g' support/cloud-image-builder/ova_generic/vmdk_ova_generic.json
      sed -i 's/minimal/'${FLAVOR}'/g' support/cloud-image-builder/ova_generic/vmdk_ova_generic.json
      cat support/cloud-image-builder/ova_generic/vmdk_ova_generic.json
   else
      generate_json "support/image-builder/ova/config_ova.json" "config_ova_generic_${FLAVOR}.json"
   fi
}

FLAVOR=$1
BRANCH=$2
LOCAL_PATH="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
echo LOCAL_PATH=$LOCAL_PATH
config_generic_ova
echo "###############################"
echo "# run git status in workspace #"
echo "###############################"
git status
