# !/bin/bash
# vim:et:ft=sh:sts=2:sw=2

DEBUG_LEVEL=${TEST_DEBUG_LEVEL-4}

# Logs the message as a warning.
#
# It is printed only if the $DEBUG_LEVEL is set above 1.
#
# Args:
#   msg: string: message to be printed
# Results:
#   None
# Throws:
#  None
Warn()
{
  local msg="$1"

  if [[ $DEBUG_LEVEL -gt 1 ]]; then
    ${ECHO} "WARNING: ${msg}"
  fi
}

# Logs the message as a informational.
#
# It is printed only if the $DEBUG_LEVEL is set above 2.
#
# Args:
#   msg: string: message to be printed
# Results:
#   None
# Throws:
#  None
Info()
{
  local msg="$1"

  if [[ $DEBUG_LEVEL -gt 2 ]]; then
    ${ECHO} "INFO: ${msg}"
  fi
}

# Logs the message as an error.
#
# Args:
#   msg: string: message to be printed
# Results:
#   None
# Throws:
#  None
Error()
{
  local msg="$1"

  ${ECHO} "ERROR: ${msg}"
}

# Logs the message as a debug information.
#
# It is printed only if the $DEBUG_LEVEL is set above 3.
#
# Args:
#   msg: string: message to be printed
# Results:
#   None
# Throws:
#  None
Debug()
{
  local msg="$1"

  if [[ $DEBUG_LEVEL -gt 3 ]]; then
    ${ECHO} "DEBUG: ${msg}"
  fi
}
