#!/bin/bash

LOG_DIR="/var/log/vmware-imc"
LOG_FILE="${LOG_DIR}/customization.log"

POST_CUSTOMIZATION_TMP_DIR=/usr/share/oem/.customization
POST_CUSTOMIZATION_TMP_SCRIPT_NAME="$POST_CUSTOMIZATION_TMP_DIR/customize.sh"

POST_REBOOT_PENDING_MARKER="$POST_CUSTOMIZATION_TMP_DIR/.guest-customization-post-reboot-pending"

DATE=/bin/date
ECHO=/bin/echo
GREP=/bin/grep
CP=/bin/cp
MV="/bin/mv -f"
SH=/bin/sh
RM="/bin/rm -f"
TEE=/usr/bin/tee
CAT=/bin/cat

if [ -f /usr/bin/logger ]; then
   LOGGER="/usr/bin/logger"
elif [ -f /bin/logger ]; then
   LOGGER="/bin/logger"
else
   LOGGER="$ECHO"
fi

Log() {
   msg="$1"
   ${LOGGER} -p local7.notice -t "NET" "customize-guest : ${msg}"
   time=`${DATE} "+%b %d %T"`
   ${ECHO} "${time} customize-guest: ${msg}" >> ${LOG_FILE}
   # NOTE: any additional logging output should not be sent to stderr, since it will be treated as customization error later
   # DEBUG: uncomment the next line if you want to have merged log in toolsDeployPkg.log
   ${ECHO} "${time} customize-guest: ${msg}"
}

AnalyzeReturnCode() {
   returnCode=$1
   msg=$2
   if [ $returnCode != 0 ]; then
      Log "WARNING: '$msg' returned with error code $returnCode"
   else
      Log "INFO: '$msg' returned successfully (error code 0)"
   fi
}

Log "Post-reboot agent started"

# Handling the case when triggers before GOSC completed or on subsequent reboots
if [ ! -f $POST_REBOOT_PENDING_MARKER ]; then
   Log "No post-reboot marker detected. Skipping"
else
   ${RM} $POST_REBOOT_PENDING_MARKER
   Log "Calling post-reboot customization script"
   ((${SH} $POST_CUSTOMIZATION_TMP_SCRIPT_NAME "postcustomization" > /tmp/stdout.log) 2>&1 | ${TEE} -a /tmp/stderr.log)
   AnalyzeReturnCode $? "Post-customization"
   out=`${CAT} /tmp/stdout.log`
   if [ x"$out" != x"" ]; then
      Log "Post-reboot customization stdout:"
      Log "$out"
   else
      Log "stdout is empty"
   fi
   out=`${CAT} /tmp/stderr.log`
   if [ x"$out" != x"" ]; then
      Log "Post-reboot customization stderr:"
      Log "$out"
   else
      Log "stderr is empty"
   fi
fi

Log "Post-reboot agent finished"
