#!/bin/bash
# vim:et:ft=sh:sts=2:sw=2

# Copyright (C) 2016-2021 VMware, Inc. All Rights Reserved.
#
# Licensed under the GNU General Public License v2 (the "License");
# you may not use this file except in compliance with the License.
# The terms of the License are located in the COPYING file of this distribution.
#

CONFIG_FILE_PATH=$1

DIRNAME="$(which dirname)"
GOSC_DIR="$(${DIRNAME} $0)"

. "${GOSC_DIR}/Utils.sh"
. "${GOSC_DIR}/Debug.sh"
. "${GOSC_DIR}/ConfigFile.sh"
. "${GOSC_DIR}/CustomizationUtils.sh"
. "${GOSC_DIR}/PhotonCustomization.sh"

# Bash version 4 is required to support associative arrays. Otherwise, it will complain about a
# missing -A option. See http://stackoverflow.com/questions/1494178/how-to-define-hash-tables-in-bash.

${ECHO} "GOSC_DIR: ${GOSC_DIR}"

${SH} --version | ${GREP} -e 'version 4.'

PhotonCustomization_Customize "${CONFIG_FILE_PATH}"
${ECHO} "Exiting"
