# !/bin/bash
# vim:et:ft=sh:sts=2:sw=2

# Wrong path causes ExitCode 1 inside the package
. "$GOSC_DIR/CustomizationUtils.sh"

RunCloudConfig()
{
  local configPath=$1

  local ciConfigPath="/tmp/cloud-config.ci"

  rm -rf /etc/systemd/network/ifcfg-*

  ConfigFile_LoadConfigFile $configPath

  tmpOvfEnvFile="/tmp/gctemp.xml"

  local scriptName=$(ConfigFile_GetCustomScriptName)

  if [[ -n "$scriptName" ]]; then
    scriptName=`${DIRNAME} $configPath`"/$scriptName"
    Info "Handling customization script [$scriptName]"
    RunCustomScript $scriptName
    InstallCustomScript $scriptName
  else
    Info "No customization script to run"
  fi

  local utc=$(ConfigFile_GetUtc)
  Debug "UTC: [$utc]"
  if [[ -z "$utc" ]]; then
    Debug "Not changing UTC"
  elif [[ $utc == 1 ]]; then
    Exec '/usr/bin/timedatectl set-local-rtc 0' '' ''
  else
    Exec '/usr/bin/timedatectl set-local-rtc 1' '' ''
  fi

  local tz=$(ConfigFile_GetTimeZone)
  Debug "Timezone: [$tz]"
  if [[ -z "$tz" ]]; then
    Debug "Not changing Timezone"
  else
    Exec "/usr/bin/timedatectl set-timezone $tz" '' ''
  fi

  GenerateCloudInitConfig content "GetInterfaceByMacAddressIPAddrShow" $tmpOvfEnvFile

  # If you don't quote the variable when you echo it, newlines are lost.
  echo "${content}" > $ciConfigPath

  Exec '/usr/bin/cloud-init --file '$ciConfigPath' init'

  Exec '/bin/systemctl restart systemd-networkd' '' ''
  
  CustomizeHostsFile

  if [[ $(ConfigFile_GetResetPassword) -eq 1 ]]; then
    Info "Resetting the password..."
    #'chage -d 0 U'/'passwd --expire U' breaks login due to missing PAM,
    #see https://github.com/coreos/bugs/issues/164
    local shadow=$(</etc/shadow)
    shadow=$(ExpireShadowRoot "$shadow")
    echo "${shadow}" > /etc/shadow
  fi
  
  machineId=$(GetBiosUuid "")

}

PhotonCustomization_Customize()
{
  local configFilePath=$1

  Info "Photon customization started"

  RunCloudConfig $configFilePath

  Info "Photon customization finished"
}
