/*
 * Copyright (C) 2021 - 2022, Stephan Mueller <smueller@chronox.de>
 *
 * License: see LICENSE file in root directory
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, ALL OF
 * WHICH ARE HEREBY DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF NOT ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */

#ifndef JITTERENTROPY_HEALTH_H
#define JITTERENTROPY_HEALTH_H

#include "jitterentropy.h"

void jent_health_cb_block_switch(void);
int jent_set_fips_failure_callback_internal(jent_fips_failure_cb cb);

static inline __u64 jent_delta(__u64 prev, __u64 next)
{
	return (next - prev);
}

#ifdef JENT_HEALTH_LAG_PREDICTOR
void jent_lag_init(struct rand_data *ec, unsigned int osr);
#else /* JENT_HEALTH_LAG_PREDICTOR */
static inline void jent_lag_init(struct rand_data *ec, unsigned int osr)
{
	(void)ec;
	(void)osr;
}
#endif /* JENT_HEALTH_LAG_PREDICTOR */

void jent_apt_init(struct rand_data *ec, unsigned int osr);
unsigned int jent_stuck(struct rand_data *ec, __u64 current_delta);
unsigned int jent_health_failure(struct rand_data *ec);

#endif /* JITTERENTROPY_HEALTH_H */
