/*
 * Copyright (C) 2021 - 2023, Stephan Mueller <smueller@chronox.de>
 *
 * License: see LICENSE file in root directory
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, ALL OF
 * WHICH ARE HEREBY DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF NOT ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */

// SPDX-License-Identifier: GPL-2.0-or-later

#ifndef JITTERENTROPY_H
#define JITTERENTROPY_H

#include "jitterentropy-common.h"


extern void *jent_zalloc(unsigned int len);
extern void jent_zfree(void *ptr, unsigned int len);
extern void jent_panic(char *s);
extern void jent_memcpy(void *dest, const void *src, unsigned int n);
extern void jent_get_nstime(__u64 *out);

extern int jent_gcd_analyze(__u64 *delta_history, size_t nelem);
extern void jent_gcd_fini(__u64 *delta_history, size_t nelem);

struct rand_data;
extern int jent_entropy_init(void);
extern ssize_t jent_read_entropy(struct rand_data *ec, char *data, size_t len);

extern struct rand_data *jent_entropy_collector_alloc(unsigned int osr,
						      unsigned int flags);
extern void jent_entropy_collector_free(struct rand_data *entropy_collector);

extern void jent_hash_time_export(struct rand_data *ec, __u64 time,
                        __u64 loop_cnt, unsigned int stuck);
extern void jent_memaccess_export(struct rand_data *ec, __u64 loop_cnt);
extern __u64 jent_hash_var_stat(struct rand_data *ec, unsigned int min);
extern void jent_get_nstime(__u64 *out);
extern unsigned int jent_measure_jitter(struct rand_data *ec,
				__u64 loop_cnt,
				__u64 *ret_current_delta);
extern unsigned int jent_health_failure(struct rand_data *ec);

#endif
