Treefile
--------

 * `ref`: string, mandatory: Holds a string which will be the name of
   the branch for the content.

 * `gpg_key` string, optional: Key ID for GPG signing; the secret key
   must be in the home directory of the building user.  Defaults to
   none.

 * `repos` array of strings, mandatory: Names of yum repositories to
   use, from any files that end in `.repo`, in the same directory as
   the treefile.  `rpm-ostree compose tree` does not use the system
   `/etc/yum.repos.d`, because it's common to want to compose a target
   system distinct from the one the host sytem is running.

 * `selinux`: boolean, optional: Defaults to `true`.  If `false`, then
   no SELinux labeling will be performed on the server side.

 * `boot_location`: string, optional: Historically, ostree put bootloader data
    in /boot.  However, this has a few flaws; it gets shadowed at boot time,
    and also makes dealing with Anaconda installation harder.  There are 3
    possible values:
    * "legacy": the default, data goes in /boot
    * "both": Kernel data in /boot and /usr/lib/ostree-boot
    * "new": Kernel data in /usr/lib/ostree-boot

 * `bootstrap_packages`: Array of strings, mandatory: The `glibc` and
   `nss-altfiles` packages (and ideally nothing else) must be in this
   set; rpm-ostree will modify the `/etc/nsswitch.conf` in the target
   root to ensure that `/usr/lib/passwd` is used.

 * `etc-group-members`: Array of strings, optional: Unix groups in this
   list will be stored in `/etc/group` instead of `/usr/lib/group`.  Use
   this option for groups for which humans should be a member.

 * `install-langs`: Array of strings, optional.  This sets the RPM
   _install_langs macro.  Set this to e.g. `["en_US", "fr_FR"]`.

 * `documentation`: boolean, optional. If this is set to false it sets the RPM
   transaction flag "nodocs" which makes yum/rpm not install files marked as
   documentation. The default is true.

 * `packages`: Array of strings, mandatory: Set of installed packages.
   Names prefixed with an `@` (e.g. `@core`) are taken to be the names
   of comps groups.

 * `units`: Array of strings, optional: Systemd units to enable by default

 * `default_target`: String, optional: Set the default systemd target

 * `initramfs-args`: Array of strings, optional.  Passed to the
    initramfs generation program (presently `dracut`).  An example use
    case for this with Dracut is `--filesystems xfs,ext4` to ensure
    specific filesystem drivers are included.

 * `remove-files`: Delete these files from the generated tree

 * `remove-from-packages`: Array, optional: Delete from specified packages
   files which match the provided array of regular expressions.
   This is safer than `remove-files` as it allows finer grained control
   with less risk of too-wide regular expressions.

   Each array element is an array, whose first member is a package name,
   and subsequent members are regular expressions (compatible with JavaScript).

   Example: `remove-from-packages: [["cpio", "/usr/share/.*"], ["dhclient", "/usr/lib/.*", "/usr/share/.*"]]`

   Note this does not alter the RPM database, so `rpm -V` will complain.

 * `preserve-passwd`: boolean, optional: Defaults to `true`.  If enabled,
   and `check-passwd` has a type other than file, copy the `/etc/passwd` (and
   `/usr/lib/passwd`) files from the previous commit if they exist. If
   check-passwd has the file type, then the data is preserved from that file to
   `/usr/lib/passwd`.
   This helps ensure consistent uid/gid allocations across builds.  However, it
   does mean that removed users will exist in the `passwd` database forever.

 * `check-passwd`: Object, optional: Checks to run against the new passwd file
   before accepting the tree. All the entries specified should exist (unless
   ignored) and have the same values or the compose will fail. There are four
   types: none (for no checking), previous (to check against the passwd file in
   the previous commit), file (to check against another passwd file), and data
   to specify the relevant passwd data in the json itself.
   Note that if you choose file, and preserve-passwd is true then the data will
   be copied from the referenced file and not the previous commit.

   Example: `check-passwd: { "type": "none" }`
   Example: `check-passwd: { "type": "previous" }`
   Example: `check-passwd: { "type": "file", "filename": "local-passwd" }`
   Example: `check-passwd: { "type": "data", "entries": { "bin": 1, "adm": [3, 4] } }`
   See also: `ignore-remove-users`

 * `check-groups`: Object, optional: Checks to run against the new group file
   before accepting the tree. All the entries specified should exist (unless
   ignored) and have the same values or the compose will fail. There are four
   types: none (for no checking), previous (to check against the group file in
   the previous commit), file (to check against another group file), and data
   to specify the relevant group data in the json itself.
   Note that if you choose file, and preserve-passwd is true then the data will
   be copied from the referenced file and not the previous commit.

   Example: `check-groups: { "type": "none" }`
   Example: `check-groups: { "type": "previous" }`
   Example: `check-groups: { "type": "file", "filename": "local-group" }`
   Example: `check-groups: { "type": "data", "entries": { "bin": 1, "adm": 4 } }`
   See also: `ignore-remove-groups`

 * `ignore-removed-users`: Array, optional: Users to ignore if they are missing
   in the new passwd file. If an entry of `*` is specified then any user can be
   removed without failing the compose.

   Example: `ignore-removed-users: ["avahi-autoipd", "tss"]`

 * `ignore-removed-groups`: Array, optional: Groups to ignore if they are missing
   in the new group file. If an entry of `*` is specified then any group can be
   removed without failing the compose.

   Example: `ignore-removed-groups: ["avahi"]`

 * `automatic_version_prefix`: String, optional: Set the prefix for versions
   on the commits. The idea is that if the previous commit on the branch to the
   doesn't match the prefix, or doesn't have a version, then the new commit will
   have the version as specified. If the prefix matches exactly, then we append
   ".1". Otherwise we parse the number after the prefix and increment it by one
   and then append that to the prefix.

   This means that on an empty branch with an automatic_version_prefix of "22"
   the first three commits would get the versions: "22", "22.1", "22.2"

   Example: `automatic_version_prefix: "22.0"`

 * `postprocess-script`: String, optional: Full filesystem path to a script
   that will be executed in the context of the target tree.  The script
   will be copied into the target into `/tmp`, and run as a container
   (a restricted chroot, with no network access).  After execution is
   complete, it will be deleted.

   It is *strongly recommended* to avoid using this except as a last resort.
   Having the system generated through RPMs allows administrators to understand
   the inputs to the system.  Any new files created through this mechanism will
   not have the versioning inherent in RPM.

   Only the script file will be copied in; thus if it has any dependencies,
   on data beyond what is in the target tree, you must embed them in the binary
   itself.

   An example use for this is working around bugs in the input RPMs that are
   hard to fix in stable releases.

   Note this does not alter the RPM database, so `rpm -V` will complain.

 * `include`: string, optional: Path to another treefile which will be
   used as an inheritance base.  The semantics for inheritance are:
   Non-array values in child values override parent values.  Array
   values are concatenated.  Filenames will be resolved relative to
   the including treefile.

 * `container`: boolean, optional: Defaults to `false`.  If `true`, then
   rpm-ostree will not do any special handling of kernel, initrd or the
   /boot directory. This is useful if the target for the tree is some kind
   of container which does not have its own kernel.
