if(NOT EXISTS "${CMAKE_ROOT}/Modules/CPack.cmake")
    message(FATAL_ERROR "Cpack module is not present!")
endif()

set(CPACK_PACKAGE_NAME "tdnf")
set(CPACK_PACKAGE_VENDOR "VMware, Inc.")
set(CPACK_PACKAGE_DESCRIPTION_SUMMARY "tdnf is a yum/dnf equivalent which uses libsolv and libcurl")
set(CPACK_PACKAGE_DESCRIPTION_FILE "${CMAKE_CURRENT_SOURCE_DIR}/README.md")
set(CPACK_PACKAGE_VERSION ${PROJECT_VERSION})
set(CPACK_RESOURCE_FILE_LICENSE "${CMAKE_CURRENT_SOURCE_DIR}/COPYING")

set(CPACK_PACKAGE_FILE_NAME "${CPACK_PACKAGE_NAME}-${CPACK_PACKAGE_VERSION}-${CMAKE_SYSTEM_PROCESSOR}")
#set(CPACK_RPM_PACKAGE_ARCHITECTURE "noarch")
set(CPACK_GENERATOR "RPM")

set(CPACK_SOURCE_GENERATOR "TGZ")
set(CPACK_SOURCE_IGNORE_FILES
    /.git
    .travis.yml
    /ci/*
    .pytest_cache/*
    __pycache__/*
    /build*
)

#set(CPACK_RPM_PRE_INSTALL_SCRIPT_FILE "${CMAKE_CURRENT_SOURCE_DIR}/pre.sh")
#set(CPACK_RPM_POST_INSTALL_SCRIPT_FILE "${CMAKE_CURRENT_SOURCE_DIR}/post.sh")
include(CPack)

