control 'PHTN-40-000173' do
  title 'The Photon operating system must generate audit records when successful/unsuccessful logon attempts occur.'
  desc  "
    Without generating audit records that are specific to the security and mission needs of the organization, it would be difficult to establish, correlate, and investigate the events relating to an incident or identify those responsible for one.

    Audit records can be generated from various components within the information system (e.g., module or policy filter).
  "
  desc  'rationale', ''
  desc  'check', "
    At the command line, run the following command to verify an audit rule exists to audit logon attempts:

    # auditctl -l | grep -E \"faillog|lastlog|tallylog\"

    Expected result:

    -w /var/log/faillog -p wa -k logons
    -w /var/log/lastlog -p wa -k logons
    -w /var/log/tallylog -p wa -k logons

    If the output does not match the expected result, this is a finding.

    Note: This check depends on the auditd service to be in a running state for accurate results. Enabling the auditd service is done in control PHTN-40-000016.
  "
  desc 'fix', "
    Navigate to and open:

    /etc/audit/rules.d/audit.STIG.rules

    Add or update the following lines:

    -w /var/log/faillog -p wa -k logons
    -w /var/log/lastlog -p wa -k logons
    -w /var/log/tallylog -p wa -k logons

    At the command line, run the following command to load the new audit rules:

    # /sbin/augenrules --load

    Note: An older audit.STIG.rules may exist if the file exists and references older \"GEN\" SRG IDs. This file can be removed and replaced as necessary with an updated one.

    Note: See supplemental document for a replacement audit.STIG.rules file.
  "
  impact 0.5
  tag severity: 'medium'
  tag gtitle: 'SRG-OS-000470-GPOS-00214'
  tag gid: nil
  tag rid: nil
  tag stig_id: 'PHTN-40-000173'
  tag cci: ['CCI-000172']
  tag nist: ['AU-12 c']

  describe auditd.file('/var/log/faillog') do
    its('permissions') { should include ['w', 'a'] }
    its('key') { should cmp 'logons' }
  end
  describe auditd.file('/var/log/lastlog') do
    its('permissions') { should include ['w', 'a'] }
    its('key') { should cmp 'logons' }
  end
  describe auditd.file('/var/log/tallylog') do
    its('permissions') { should include ['w', 'a'] }
    its('key') { should cmp 'logons' }
  end
end
