control 'PHTN-40-000127' do
  title 'The Photon operating system must install AIDE to detect changes to baseline configurations.'
  desc  "
    Unauthorized changes to the baseline configuration could make the system vulnerable to various attacks or allow unauthorized access to the operating system. Changes to operating system configurations can have unintended side effects, some of which may be relevant to security.

    Detecting such changes and providing an automated response can help avoid unintended, negative consequences that could ultimately affect the security state of the operating system. The operating system's IMO/ISSO and SAs must be notified via email and/or monitoring system trap when there is an unauthorized modification of a configuration item.
  "
  desc  'rationale', ''
  desc  'check', "
    At the command line, run the following commands to verify AIDE is installed and used to monitor for file changes:

    # rpm -qa | grep aide

    Example result:

    aide-0.16.2-3.ph4.x86_64

    If AIDE is not installed, this is a finding.
  "
  desc 'fix', "
    At the command line, run the following command:

    # tdnf install aide
  "
  impact 0.5
  tag severity: 'medium'
  tag gtitle: 'SRG-OS-000363-GPOS-00150'
  tag gid: nil
  tag rid: nil
  tag stig_id: 'PHTN-40-000127'
  tag cci: ['CCI-001744']
  tag nist: ['CM-3 (5)']

  describe command('rpm -qa | grep aide') do
    its('stdout.strip') { should match /aide-/ }
  end
end
