control 'PHTN-40-000013' do
  title 'The Photon operating system must have the OpenSSL FIPS provider installed.'
  desc  "
    Without confidentiality protection mechanisms, unauthorized individuals may gain access to sensitive information via a remote access session.

    OpenSSH on the Photon operating system when configured appropriately can utilize a FIPS validated OpenSSL for cryptographic operations.
  "
  desc  'rationale', ''
  desc  'check', "
    At the command line, run the following command to verify the OpenSSL FIPS provider is installed:

    # rpm -qa | grep openssl-fips

    Example result:

    openssl-fips-provider-3.0.3-1.ph4.x86_64

    If there is no output indicating that the OpenSSL FIPS provider is installed, this is a finding.
  "
  desc 'fix', "
    At the command line, run the following command:

    # tdnf install openssl-fips-provider
  "
  impact 0.5
  tag severity: 'medium'
  tag gtitle: 'SRG-OS-000033-GPOS-00014'
  tag satisfies: ['SRG-OS-000393-GPOS-00173', 'SRG-OS-000394-GPOS-00174', 'SRG-OS-000423-GPOS-00187', 'SRG-OS-000425-GPOS-00189', 'SRG-OS-000426-GPOS-00190']
  tag gid: nil
  tag rid: nil
  tag stig_id: 'PHTN-40-000013'
  tag cci: ['CCI-000068', 'CCI-002890', 'CCI-003123', 'CCI-002418', 'CCI-002420', 'CCI-002422']
  tag nist: ['AC-17 (2)', 'MA-4 (6)', 'MA-4 (6)', 'SC-8', 'SC-8 (2)', 'SC-8 (2)']

  describe command('rpm -qa | grep openssl-fips') do
    its('stdout.strip') { should match /openssl-fips-provider/ }
  end
end
