control 'PHTN-40-000238' do
  title 'The Photon operating system must generate audit records for all access and modifications to the opasswd file.'
  desc  'Without the capability to generate audit records, it would be difficult to establish, correlate, and investigate the events relating to an incident or identify those responsible for one.'
  desc  'rationale', ''
  desc  'check', "
    At the command line, run the following command to verify an audit rule exists to audit the opasswd file:

    # auditctl -l | grep -E /etc/security/opasswd

    Expected result:

    -w /etc/security/opasswd -p wa -k opasswd

    If the opasswd file is not monitored for access or writes, this is a finding.

    Note: This check depends on the auditd service to be in a running state for accurate results. Enabling the auditd service is done in control PHTN-40-000016.
  "
  desc 'fix', "
    Navigate to and open:

    /etc/audit/rules.d/audit.STIG.rules

    Add or update the following lines:

    -w /etc/security/opasswd -p wa -k opasswd

    At the command line, run the following command to load the new audit rules:

    # /sbin/augenrules --load

    Note: An older audit.STIG.rules may exist if the file exists and references older \"GEN\" SRG IDs. This file can be removed and replaced as necessary with an updated one.

    Note: See supplemental document for a replacement audit.STIG.rules file.
  "
  impact 0.5
  tag severity: 'medium'
  tag gtitle: 'SRG-OS-000480-GPOS-00227'
  tag gid: nil
  tag rid: nil
  tag stig_id: 'PHTN-40-000238'
  tag cci: ['CCI-000366']
  tag nist: ['CM-6 b']

  describe auditd.file('/etc/security/opasswd') do
    its('permissions') { should include ['w', 'a'] }
    its('key') { should cmp 'opasswd' }
  end
end
