# 0.Introduction

This document is aiming to guide user to update their exiting clusters pointing to the certificate updated airgap repository server. Currently only TCA appliance based is supported, CN is not in the scope of this document.

In this scenario, user need to update a couple of entities with the latest airgap repository server self-signed certificate  or private root CA certificate, including:

- TCA manager DB to update the airgap repo CA certificate info defined in partner system
- tkgcontexts in k8s-bootstrapper (aka TCA-CP KBS) that pointing to the corresponding airgap repo
- update existing cluster nodes' system and containerd ca cert file
- update the kubecontrolplane and kubeadmconfigtemplate relevant CRs on management clusters
- update management cluster configmaps: kapp-controller-config and tkr-controller-config
- update workload cluster relevant secret on management cluster: <cluster-name>-kapp-controller-addon
- update workload cluster configmap: kapp-controller-config

As the complexity metioned above, a tool is provided which can be run on TCA CP appliance to help update all the existing clusters managed by that TCA CP (refer to section 1), but the DB updating is required user to execute manually (refer to section 3)

The tool classified the updating into 4 parts:

- update kbs tkg contexts, so that creating new node pool of management cluster/v1 workload cluster can work
- update all management clusters pointing to the airggped repo, so that these management cluster can create new clusters/install new addons
- update all v1 workload clusters pointing to the airgapped repo, so that these workload clusters can scale in and out/install new addons/customized

The tool also provides a single command to update all the above componnets, and verify the results.

User can execute it to check the updating status.

This guide also provides manual steps of updating CA of a single cluster, as a reference in case any issue when executing the updating tools (refer to section 3)

Idealy, **user can work with following steps to get it updated**:

- Step 1: follow section 3 to update TCA manager DB
- Step 2: follow section 1.0 and 1.1 to update Cluster components from TCA-CP

Other sections only provide information to check when some errors occurs.

# 1.Update Cluster CA certificate via Tool

## 1.0 Uploading update CA tool to TCA CP appliance

1. download the [tarball](https://vmwaresaas.jfrog.io/artifactory/generic-registry/airgap/update-ca-v2.0.tar.gz) of the update ca tool, and copy it to TCA CP appliance (named as update-ca-v2.0.tar.gz in the following example)
2. upload the airgap repository server self-signed certificate or private root CA certificate to TCA CP appliance (named as ca.crt in the following example)

login to TCA CP appliance via SSH

```shell
# scp update-ca-v2.0.tar.gz admin@<tcacpip>:~
# scp ca.crt admin@<tcacpip>:~
# ssh admin@<tcacpip>
[admin@tcacp ~]$ su
Password:
[root@tcacp /home/admin] ls
update-ca-v2.0.tar.gz
[root@tcacp /home/admin] tar vxfz update-ca-v2.0.tar.gz
[root@tcacp /home/admin] ls
update-ca update-ca-v2.0.tar.gz
[root@tcacp /home/admin] cd update-ca
[root@tcacp /home/admin/update-ca] ls
ansible update_ca.py
[root@tcacp /home/admin/update-ca] ./update_ca.py -h
usage: update_ca.py [-h] [--loglevel {debug,info,error,warning,critical}]
                    [--logdst {console,file}]
                    [--ansible_log_file ANSIBLE_LOG_FILE]
                    {update-tkgcontexts,update-mgmtclusters,update-v1clusters,update-v2clusters,update-all,verify-all}
                    ...

TCA CaaS update airgap repository CA certificate tool

positional arguments:
  {update-tkgcontexts,update-mgmtclusters,update-v1clusters,update-v2clusters,update-all,verify-all}
                        -h for additional help
    update-tkgcontexts  update KBS tkg contexts airgap CA certificate
    update-mgmtclusters
                        update mgmt clusters associating with the airgap
                        repository
    update-v1clusters   update v1 workload clusters associating with the
                        airgap repository
    update-all          update airgap CA certificate on all relevant
                        components of TCA-CP
    verify-all          verify all relevant components of TCA-CP have updated
                        CA content

optional arguments:
  -h, --help            show this help message and exit
  --loglevel {debug,info,error,warning,critical}
                        log level of script
  --logdst {console,file}
                        log destination
  --ansible_log_file    ANSIBLE_LOG_FILE
                        log file path if the logging to a file
```



## 1.1 Verify and Update all relevant components

### 1.1.1 Verify all the relevant components having the updated airgap repository server CA certificate

Run this command to simply verify all the relevant components associating the TCA-CP.

```shell
[root@tcacp /home/admin/update-ca] ./update_ca.py verify-all -h

usage: update_ca.py verify-all [-h] --fqdn FQDN --cafile CAFILE

optional arguments:
  -h, --help       show this help message and exit

required arguments:
  --fqdn FQDN      FQDN of the airgap repository server
  --cafile CAFILE  new CA certificate file of the airgap repository server
```

For e.g

```shell
[root@tcacp /home/admin/update-ca]./update_ca.py verify-all --fqdn airgap-repo-server-2.ipv6.eng.vmware.com --cafile /home/admin/ca.crt
update_ca[INFO]: airgap repo: airgap-repo-server-2.ipv6.eng.vmware.com is valid
update_ca[INFO]: ########## verifying tkgcontexts ##########
update_ca[INFO]: tkgcontext[48fb570d-2226-4902-a893-3df2dbff97fd]: up to date
update_ca[INFO]: tkgcontext[5123887a-da9f-4312-8292-4d595c098a57]: up to date
update_ca[INFO]: ########## verifying management clusters ##########
update_ca[INFO]: # verifying management cluster[mc200], id[a1d9dcc8-d43f-4278-909e-0a22009a21db]
update_ca[INFO]: configmap kapp-controller-config/tkg-system: up to date
update_ca[INFO]: configmap tkr-controller-config/tkr-system: up to date
update_ca[INFO]: kubecontrolplane cr[mc200-master-control-plane/tkg-system]: up to date
update_ca[INFO]: kubeadmconfigtemplate cr[mc200-np1/tkg-system]: up to date
update_ca[INFO]: node[172.16.69.14]: up to date
update_ca[INFO]: node[172.16.68.231]: up to date
update_ca[INFO]: ########## verifying v1 workload clusters ##########
update_ca[INFO]: # verifying workload cluster[wc200v1], id[57a25f87-4718-4597-85f2-20926005de78]
update_ca[INFO]: configmap kapp-controller-config/tkg-system: up to date
update_ca[INFO]: kubecontrolplane cr[wc200v1-master-control-plane/wc200v1]: up to date
update_ca[INFO]: kubeadmconfigtemplate cr[wc200v1-np1/wc200v1]: up to date
update_ca[INFO]: query cluster wc200v1 node ips
update_ca[INFO]: node[172.16.68.224]: up to date
update_ca[INFO]: node[172.16.69.30]: up to date
```

If all output logs are INFO and components are show "up to date", then the system is already with the right CA file.

If the output logs has ERROR/CRITICAL message, some components may show "out of date", it is required to update the components  with the new CA file with commands specified in section 1.1.2 or 1.2 - 1.4. Take following command and output for e.g

```shell
[root@tcacp /home/admin/update-ca]./update_ca.py verify-all --fqdn airgap-repo-server-2.ipv6.eng.vmware.com --cafile /home/admin/ca.crt
update_ca[INFO]: airgap repo: airgap-repo-server-2.ipv6.eng.vmware.com is valid
update_ca[INFO]: ########## verifying tkgcontexts ##########
update_ca[ERROR]: tkgcontext[5123887a-da9f-4312-8292-4d595c098a57]: out of date
update_ca[ERROR]: tkgcontext[48fb570d-2226-4902-a893-3df2dbff97fd]: out of date
update_ca[INFO]: ########## verifying management clusters ##########
update_ca[INFO]: # verifying management cluster[mc200], id[a1d9dcc8-d43f-4278-909e-0a22009a21db]
update_ca[ERROR]: configmap kapp-controller-config/tkg-system: out of date
update_ca[ERROR]: configmap tkr-controller-config/tkr-system: out of date
update_ca[ERROR]: kubecontrolplane cr[mc200-master-control-plane/tkg-system]: out of date
update_ca[ERROR]: kubeadmconfigtemplate cr[mc200-np1/tkg-system]: out of date
update_ca[ERROR]: node[172.16.69.14]: out of date, SSL certificate problem
update_ca[ERROR]: node[172.16.68.231]: out of date, SSL certificate problem
update_ca[INFO]: ########## verifying v1 workload clusters ##########
update_ca[INFO]: # verifying workload cluster[wc200v1], id[57a25f87-4718-4597-85f2-20926005de78]
update_ca[INFO]: configmap kapp-controller-config/tkg-system: up to date
update_ca[ERROR]: kubecontrolplane cr[wc200v1-master-control-plane/wc200v1]: out of date
update_ca[ERROR]: kubeadmconfigtemplate cr[wc200v1-np1/wc200v1]: out of date
update_ca[INFO]: query cluster wc200v1 node ips
update_ca[ERROR]: node[172.16.68.224]: out of date, SSL certificate problem
update_ca[ERROR]: node[172.16.69.30]: out of date, SSL certificate problem
```



If you'd like to visit more info on the exact commands the script is executing to verify, try following commands with loglevel to debug

```shell
[root@tcacp /home/admin/update-ca]./update_ca.py --loglevel debug verify-all --fqdn airgap-repo-server-2.ipv6.eng.vmware.com --cafile /home/admin/ca.crt
```



### 1.1.2 Update all the relevant components with new CA certificate

Run this command to simply update all the relevant components associating the TCA-CP, which will cover the executions in section 1.2, 1.3 and 1.4. If you run this command successfully, it is not required to run the following other commands.

```shell
[root@tcacp /home/admin/update-ca] ./update_ca.py update-all -h
usage: update_ca.py all [-h] --fqdn FQDN --cafile CAFILE --vcpass VCPASS

optional arguments:
  -h, --help       show this help message and exit

required arguments:
  --fqdn FQDN      FQDN of the airgap repository server
  --cafile CAFILE  new CA certificate file of the airgap repository server
  --vcpass VCPASS  vCenter Password
```

for e.g.

```shell
[root@tcacp /home/admin/update-ca] ./update_ca.py update-all --fqdn airgap-repo-server.example.com --cafile /home/admin/ca.crt --vcpass password
```



Note that during the updating, cluster control plane nodes will be redeployed that may lead to cluster temporary access issue, in case of single cluster control plane node. The script might fail in some step because of it. The script can be run again and again util no error reported.



## 1.2 Update KBS tkgcontexts

Run this command to update KBS tkgcontexts

```shell
[root@tcacp /home/admin/update-ca] ./update_ca.py tkgcontexts -h
usage: update_ca.py tkgcontexts [-h] --fqdn FQDN --cafile CAFILE --vcpass VCPASS

optional arguments:
  -h, --help       show this help message and exit

required arguments:
  --fqdn FQDN      FQDN of the airgap repository server
  --cafile CAFILE  new CA certificate file of the airgap repository server
  --vcpass VCPASS  vCenter Password
```

for e.g.

```shell
[root@tcacp /home/admin/update-ca] ./update_ca.py tkgcontexts --fqdn airgap-repo-server.example.com --cafile /home/admin/ca.crt --vcpass password
```

> Check the output messages on console for any errors/progress.

## 1.3 Update all Management Clusters

```shell
[root@tcacp /home/admin/update-ca] ./update_ca.py mgmtclusters -h
usage: update_ca.py mgmtclusters [-h] --fqdn FQDN --cafile CAFILE

optional arguments:
  -h, --help       show this help message and exit

required arguments:
  --fqdn FQDN      FQDN of the airgap repository server
  --cafile CAFILE  new CA certificate file of the airgap repository server
```

for e.g

```shell
[root@tcacp /home/admin/update-ca] ./update_ca.py mgmtclusters --fqdn airgap-repo-server.example.com --cafile  /home/admin/ca.crt
```

> After running this step successfully, you can operate the management clusters as usual, for e.g creating new workload clusters on the updated management clusters

## 1.4 Update all v1 Workload Clusters

```shell
[root@tcacp /home/admin/update-ca]./update_ca.py v1clusters -h
usage: update_ca.py v1clusters [-h] --fqdn FQDN --cafile CAFILE

optional arguments:
  -h, --help       show this help message and exit

required arguments:
  --fqdn FQDN      FQDN of the airgap repository server
  --cafile CAFILE  new CA certificate file of the airgap repository server
```

for e.g

```shell
[root@tcacp /home/admin/update-ca] ./update_ca.py v1clusters --fqdn airgap-repo-server.example.com --cafile  /home/admin/ca.crt
```

> After running this step successfully,  you can operate v1 workload clusters as usual, for e.g, add node pool, scale out an existing node pool, install new addons etc.


# 2. Manual Steps to update single cluster CA certificate

## 2.0 Preparations

some inputs are require ca certificate in base64, so we need to get the base64 encoded string for the CA certificate, with following commands

```shell
# base64 /home/admin/ca.crt -w 0
```



## 2.1 Update a management cluster

### 2.1.0 Get resources

#### 2.1.0.1 Find the management cluster id to update via ccli

for. e.g

```shell
# ccli list mc

+-------+------------------+------------------+--------------------------------------+--------------+----------+
| INDEX | NAME             | CONTEXT          | ID                                   | CONNECTIVITY | SELECTED |
+-------+------------------+------------------+--------------------------------------+--------------+----------+
| 0     | ipv4-airgap-mgmt | ipv4-airgap-mgmt | 97bad1f2-bbed-4019-b226-b211f50bb3f4 | true         |          |
| 1     | ipv4-mgmt        | ipv4-mgmt        | b8e55039-63f8-447c-93c3-b86bf26c8412 | true         |          |
+-------+------------------+------------------+--------------------------------------+--------------+----------+
# ccli go 0
```



In the following "ipv4-airgap-mgmt" cluster is used as an example, with id "97bad1f2-bbed-4019-b226-b211f50bb3f4"

#### 2.1.0.2 Locate management cluster kubeconfig file

it locates at "/opt/vmware/k8s-bootstrapper/<cluster id>/kubeconfig, and create an alias to shorten the following command line

```shell
# ls /opt/vmware/k8s-bootstrapper/97bad1f2-bbed-4019-b226-b211f50bb3f4/
kubeconfig
# alias mk="kubectl --kubeconfig /opt/vmware/k8s-bootstrapper/97bad1f2-bbed-4019-b226-b211f50bb3f4/kubeconfig"
```

### 2.1.1 Update tkgcontext of management cluster

#### 2.1.1.1 Get cluster tkgcontext id, in the output "tkgID" is the tkgcontext id to update

```shell
# ccli show spec
tkgID: 38561a18-3ea9-402f-9568-dca4889a6b11
id: 97bad1f2-bbed-4019-b226-b211f50bb3f4
clusterName: ipv4-airgap-mgmt
kubernetesVersion: v1.22.8+vmware.1
serviceCIDR: 100.64.0.0/13
clusterCIDR: 100.96.0.0/11
....
```

#### 2.1.1.2 Save , edit and update tkgcontext

```shell
# curl -X GET http://localhost:8888/api/v1/tkgcontext/38561a18-3ea9-402f-9568-dca4889a6b11 | python -m json.tool > tkgcontext.json
# vi tkgcontext.json # update vc password and caCert
{
    "id": "38561a18-3ea9-402f-9568-dca4889a6b11",
    "ipFamilies": "IPv4",
    "infrastructure": {
        "type": "vsphere",
        "version": "7.0.3"
    },
    "vsphere": {
        "password": "<my vc password>"
        ...
    },
    "airgap": {
        "fqdn": "airgap-repo-serve.example.com",
        "caCert": "<update it with new ca.crt base64 string"
        }
    }
}
# curl -X PUT http://localhost:8888/api/v1/tkgcontext/38561a18-3ea9-402f-9568-dca4889a6b11 -d "`cat tkgcontext.json`"
```

### 2.1.2 Update management cluster nodes

#### 2.1.2.1 get cluster node IPs

```shell
# ccli show status
status: Running
phase: PostConfig
nodes:
- ip: 172.16.69.112
  vmName: ipv4-airgap-mgmt-master-control-plane-qc6nx
  ...
- ip: 172.16.69.213
  vmName: ipv4-airgap-mgmt-np1-7648d7cd8f-79xvg
  ...
- ip: 172.16.70.143
  vmName: ipv4-airgap-mgmt-np1-7648d7cd8f-svmz9
  ...
```

#### 2.1.2.2  login node and update CA cert

for each node we need to login and update, here we take one node for example:

```shell
# ssh capv@172.16.69.112
capv@ipv4-airgap-mgmt-master-control-plane-qc6nx [ ~ ]$ sudo su
root [ /home/capv ]# vi ca.crt # copy the ca cert content to this file
root [ /home/capv ]# cp ca.crt /etc/ssl/certs/airgap-repo-server.example.com.pem # end with .pem is a must!
root [ /home/capv ]# rehash_ca_certificates.sh
root [ /home/capv ]# curl https://airgap-repo-server.example.com -v --head # test it works
root [ /home/capv ]# cp ca.crt /etc/containerd/airgap-repo-server.example.com.crt
root [ /home/capv ]# systemctl restart containerd
root [ /home/capv ]# systemctl status containerd
root [ /home/capv ]# crictl pull airgap-repo-server.example.com/registry/tkr-compatibility:v1 # test pulling from airgap repo
```



### 2.1.3 Update management cluster configmaps

#### 2.1.3.1 update tkr-controller-config

```shell
# mk edit cm tkr-controller-config -n tkr-system
# Please edit the object below. Lines beginning with a '#' will be ignored,
# and an empty file will abort the edit. If an error occurs while saving this file will be
# reopened with the relevant failures.
#
apiVersion: v1
data:
  caCerts: |
    -----BEGIN CERTIFICATE-----
    ...
    -----END CERTIFICATE-----
  imageRepository: airgap-repo-server.example.com/registry
...
```

copy the new ca certificate content and overwrite existing caCerts field

save it with ":wq"

then restart tkr-controller-manager

```shell
# mk rollout restart deployment -n tkr-system tkr-controller-manager
```



#### 2.1.3.2 update kapp-controller-config

```shell
# mk edit cm kapp-controller-config -n tkg-system
# Please edit the object below. Lines beginning with a '#' will be ignored,
# and an empty file will abort the edit. If an error occurs while saving this file will be
# reopened with the relevant failures.
#
apiVersion: v1
data:
  caCerts: |
    -----BEGIN CERTIFICATE-----
    ...
    -----END CERTIFICATE-----
  imageRepository: airgap-repo-server.example.com/registry
...
```

copy the new ca certificate content and overwrite existing caCerts field

save it with ":wq"

then restart kapp-controller-manager

```shell
# mk rollout restart deployment -n tkg-system kapp-controller
```

### 2.1.4 Update management cluster kubecontrolplane and kubeadmconfigtemplate CRs

#### 2.1.4.1 Update Management cluster kcp (kubecontrolplane) CR

```
# mk get kcp -n tkg-system
NAME                                    CLUSTER            INITIALIZED   API SERVER AVAILABLE   REPLICAS   READY   UPDATED   UNAVAILABLE   AGE   VERSION
ipv4-airgap-mgmt-master-control-plane   ipv4-airgap-mgmt   true          true                   1          1       1         0             11d   v1.22.8+vmware.1
# mk edit kcp -n tkg-system ipv4-airgap-mgmt-master-control-plane
...
    - content: <cert-base64-content>
      encoding: base64
      path: /etc/containerd/airgap-repo-server.example.crt
      permissions: "0444"
...
```

locate the airgap repo certificate file content, and update it with CA certificate base64 string.

save it with ":wq"

#### 2.1.4.2 Update management cluster kct (kubeadmconfigtemplate) CR

```
# mk get kubeadmconfigtemplate -n tkg-system
NAME                   AGE
ipv4-airgap-mgmt-np1   11d
# mk edit kubeadmconfigtemplate -n tkg-system ipv4-airgap-mgmt-np1
...
spec:
  template:
    spec:
      files:
      - content: <cert-base64-content>
        encoding: base64
        path: /etc/containerd/airgap-repo-server.example.com.crt
        permissions: "0444"
...
```

locate the airgap repo certificate file content, and update it with CA certificate base64 string.

save it with ":wq"

## 2.2 Update a v1 workload cluster

### 2.2.0 Get resources

#### 2.2.0.1 Find the workload cluster id to update via ccli

```shell
# ccli list wc
+-------+------------------+------------------+------------------------------------------+----------------------------+--------------+----------+---------------------+
| INDEX | NAME             | CONTEXT          | ID                                       | VCENTER ADDRESSES          | CONNECTIVITY | SELECTED | TYPE                |
+-------+------------------+------------------+------------------------------------------+----------------------------+--------------+----------+---------------------+
| 0     | ipv4-airgap-v1wc | ipv4-airgap-v1wc | 1fabca0a-ac69-406f-950a-92e7ddf7c4ae     | vc70u3.ipv6.eng.vmware.com | true         |          | KBS                 |
+-------+------------------+------------------+------------------------------------------+----------------------------+--------------+----------+---------------------+
# ccli go 0
```

in the following example, we will update cluster "ipv4-airgap-v1wc" with id "1fabca0a-ac69-406f-950a-92e7ddf7c4ae"



#### 2.2.0.2 Locate workload cluster kubeconfig file

it locates at "/opt/vmware/k8s-bootstrapper/<cluster id>/kubeconfig, and create an alias to shorten the following command lines

```shell
# ls /opt/vmware/k8s-bootstrapper/1fabca0a-ac69-406f-950a-92e7ddf7c4ae/
kubeconfig
# alias wk="kubectl --kubeconfig /opt/vmware/k8s-bootstrapper/1fabca0a-ac69-406f-950a-92e7ddf7c4ae/kubeconfig"
```



#### 2.2.0.3 Locate workload cluster's management cluster kubeconfig file

```shell
# ccli show spec
tkgID: 189118fc-232c-4119-9ad6-5669b0a63654
id: 1fabca0a-ac69-406f-950a-92e7ddf7c4ae
tkgMgmtClusterId: 97bad1f2-bbed-4019-b226-b211f50bb3f4
...
# alias mk="kubectl --kubeconfig /opt/vmware/k8s-bootstrapper/97bad1f2-bbed-4019-b226-b211f50bb3f4/kubeconfig"
```



### 2.2.1 Update tkgcontext of v1 workload cluster

#### 2.2.1.1 Get cluster tkgcontext id, in the output "tkgID" is the tkgcontext id to update

```shell
# ccli show spec
tkgID: 189118fc-232c-4119-9ad6-5669b0a63654
id: 1fabca0a-ac69-406f-950a-92e7ddf7c4ae
tkgMgmtClusterId: 97bad1f2-bbed-4019-b226-b211f50bb3f4
tkgManagementNamespace: ipv4-airgap-v1wc
clusterName: ipv4-airgap-v1wc
clusterPassword: '***'
kubernetesVersion: v1.22.8+vmware.1
serviceCIDR: 100.64.0.0/13
clusterCIDR: 100.96.0.0/11
```

tkgID: 189118fc-232c-4119-9ad6-5669b0a63654 is the tkgcontext id to update

#### 2.2.1.2 Save , edit and update tkgcontext

This step is exactly the same with the ones in section 2.1.1.2, but a different tkgcontext id. Refer to section 2.1.1.2.

### 2.2.2 Update v1 workload cluster nodes

This steps are exactly the same with the ones in section 2.1.2.1 and 2.1.2.2. Refer to steps in section 2.1.2.

### 2.2.3 Update v1 workload cluster kapp controller

#### 2.2.3.1 Update kapp controller addon secret on management cluster

Save cluster kapp controller addon secret to a file

```shell
# mk get secret -n ipv4-airgap-v1wc ipv4-airgap-v1wc-kapp-controller-addon -o jsonpath={.data."values\.yaml"} | base64 -d > kapp.yaml
```

edit kapp.yaml with new CA certificate, and save it with ":wq"

```yaml
# vi kapp.yaml
#@data/values
#@overlay/match-child-defaults missing_ok=True
---
kappController:
  ...
  config:
    caCerts: |-
      -----BEGIN CERTIFICATE-----
      <update this content with new CA certificate content>
      -----END CERTIFICATE-----
```

patch secret

```
# mk patch secret -n ipv4-airgap-v1wc ipv4-airgap-v1wc-kapp-controller-addon -p "{\"data\":{\"values.yaml\": \"`base64 kapp.yaml -w 0`\"}}"
```

#### 2.2.3.2 Update kapp controller configmap on workload cluster

for workload cluster only kapp-controller-config is required to be updated, pls refer to step in section 2.1.3.2. The only difference is using alias "wk" instead of "mk"

### 2.2.4 Update v1 workload cluster kubecontrolplane and kubeadmconfigtemplate CRs on its management cluster

#### 2.2.4.1 Update v1 workload cluster kcp (kubecontrolplane) CR

```shell
# mk get kcp -n ipv4-airgap-v1wc
NAME                                    CLUSTER            INITIALIZED   API SERVER AVAILABLE   REPLICAS   READY   UPDATED   UNAVAILABLE   AGE   VERSION
ipv4-airgap-v1wc-master-control-plane   ipv4-airgap-v1wc   true          true                   1          1       1         0             11d   v1.22.8+vmware.1
# mk edit kcp -n ipv4-airgap-v1wc ipv4-airgap-v1wc-master-control-plane
...
    - content: <cert-base64-content>
      encoding: base64
      path: /etc/containerd/airgap-repo-server.example.crt
      permissions: "0444"
...
```

locate the airgap repo certificate file content, and update it with CA certificate base64 string.

save it with ":wq"

#### 2.1.4.2 Update v1 workload cluster kct (kubeadmconfigtemplate) CRs

```shell
# mk get kubeadmconfigtemplate -n ipv4-airgap-v1wc
NAME                   AGE
ipv4-airgap-v1wc-np1   11d
# mk edit kubeadmconfigtemplate -n ipv4-airgap-v1wc ipv4-airgap-v1wc-np1
...
spec:
  template:
    spec:
      files:
      - content: <cert-base64-content>
        encoding: base64
        path: /etc/containerd/airgap-repo-server.example.com.crt
        permissions: "0444"
...
```

locate the airgap repo certificate file content, and update it with CA certificate base64 string.

save it with ":wq"

> Note that, in this example there's only one node pool in the cluster. for multiple node pools, each node pool's kubeadmconfigtemplate must be updated one by one.


# 3 Update TCA manager DB

## 3.1 TCA 2.0.x Mongo DB

### 3.1.1 Step 1: Prepare base64 string of the new CA certificate

```shell
# base64 <ca.crt> -w 0
```

### 3.1.2 Step 2: Login to TCA Manager Appliance via SSH

```shell
# ssh admin@<tca-m ip>
```

### 3.3.3 Step 3: Update mongo DB with the CA certificate base64 string

```shell
[admin@tcam ~]$ mongo hybridity
MongoDB shell version: 3.2.5
connecting to: hybridity
Server has startup warnings:
2022-09-29T07:28:31.017+0000 I CONTROL  [initandlisten]
2022-09-29T07:28:31.018+0000 I CONTROL  [initandlisten] ** WARNING: Access control is not enabled for the database.
2022-09-29T07:28:31.018+0000 I CONTROL  [initandlisten] **          Read and write access to data and configuration is unrestricted.
2022-09-29T07:28:31.018+0000 I CONTROL  [initandlisten]
> db.Extension.find().pretty()
> db.Extension.update({"name":"<name>"},{$set:{"interfaceInfo.caCert":"<CA base64 content>"}});
WriteResult({ "nMatched" : 1, "nUpserted" : 0, "nModified" : 1 })
```

Please replace the db.Extension.update command with the real "airgap repository server fqdn" and the "base64 string of CA certificate" (output of Step 1)
