# 0.Introduction

This document is aiming to guide user to update their exiting clusters pointing to the certificate updated airgap repository server. Currently only TCA appliance based is supported, CN is not in the scope of this document.

In this scenario, user need to update a couple of entities with the latest airgap repository server self-signed certificate  or private root CA certificate, including:

- TCA manager DB to update the airgap repo CA certificate info defined in partner system
- tkgcontexts in k8s-bootstrapper (aka TCA-CP KBS) that pointing to the corresponding airgap repo
- update existing cluster nodes' system and containerd ca cert file
- management cluster CR in minikube on TCA-CP appliance
- update the kubecontrolplane and kubeadmconfigtemplate relevant CRs on management clusters
- update management cluster secrets if needed
- update management cluster configmaps: kapp-controller-config and tkr-controller-config
- update workload cluster relevant secret on management cluster: <cluster-name>-kapp-controller-addon
- update workload cluster configmap: kapp-controller-config
- update tcakubenetescluster cr on management cluster after disabling tca-kubecluster-operator (aka TKO) webhook

As the complexity metioned above, a tool is provided which can be run on TCA CP appliance to help update all the existing clusters managed by that TCA CP (refer to section 1), but the DB updating is required user to execute manually (refer to section 3)

The tool classified the updating into 4 parts:

- update kbs tkg contexts, so that creating new node pool of management cluster/v1 workload cluster can work
- update all management clusters pointing to the airggped repo, so that these management cluster can create new clusters/install new addons
- update all v1 workload clusters pointing to the airgapped repo, so that these workload clusters can scale in and out/install new addons/customized
- update all v2 workload clusters pointing to the airgapped repo, so that these workload clusters can scale in and out/install new addons/customized

The tool also provides a single command to update all the above componnets, and verify the results.

User can execute it to check the updating status.

This guide also provides manual steps of updating CA of a single cluster, as a reference in case any issue when executing the updating tools (refer to section 3)

Idealy, **user can work with following steps to get it updated**:

- Step 1: follow section 3 to update TCA manager DB
- Step 2: follow section 1.0 and 1.1 to update Cluster components from TCA-CP

Other sections only provide information to check when some errors occurs.

# 1.Update Cluster CA certificate via Tool

## 1.0 Uploading update CA tool to TCA CP appliance

1. download the [tarball](https://vmwaresaas.jfrog.io/artifactory/generic-registry/airgap/update-ca-v2.3.tar.gz) of the update ca tool, and copy it to TCA CP appliance (named as update-ca-v2.3.tar.gz in the following example)
2. upload the airgap repository server self-signed certificate or private root CA certificate to TCA CP appliance (named as ca.crt in the following example)

login to TCA CP appliance via SSH

```shell
# scp update-ca-v2.3.tar.gz admin@<tcacpip>:~
# scp ca.crt admin@<tcacpip>:~
# ssh admin@<tcacpip>
[admin@tcacp ~]$ su
Password:
[root@tcacp /home/admin] ls
update-ca-v2.3.tar.gz
[root@tcacp /home/admin] tar vxfz update-ca-v2.3.tar.gz
[root@tcacp /home/admin] ls
update-ca update-ca-v2.3.tar.gz
[root@tcacp /home/admin] cd update-ca
[root@tcacp /home/admin/update-ca] ls
ansible update_ca.py
[root@tcacp /home/admin/update-ca] ./update_ca.py -h
usage: update_ca.py [-h] [--loglevel {debug,info,error,warning,critical}]
                    [--logdst {console,file}]
                    [--ansible_log_file ANSIBLE_LOG_FILE]
                    {update-tkgcontexts,update-mgmtclusters,update-v1clusters,update-v2clusters,update-all,verify-all}
                    ...

TCA CaaS update airgap repository CA certificate tool

positional arguments:
  {update-tkgcontexts,update-mgmtclusters,update-v1clusters,update-v2clusters,update-all,verify-all}
                        -h for additional help
    update-tkgcontexts  update KBS tkg contexts airgap CA certificate
    update-mgmtclusters
                        update mgmt clusters associating with the airgap
                        repository
    update-v1clusters   update v1 workload clusters associating with the
                        airgap repository
    update-v2clusters   update v2 workload clusters associating with the
                        airgap repository
    update-all          update airgap CA certificate on all relevant
                        components of TCA-CP
    verify-all          verify all relevant components of TCA-CP have updated
                        CA content

optional arguments:
  -h, --help            show this help message and exit
  --loglevel {debug,info,error,warning,critical}
                        log level of script
  --logdst {console,file}
                        log destination
  --ansible_log_file    ANSIBLE_LOG_FILE
                        log file path if the logging to a file
```



## 1.1 Verify and Update all relevant components

### 1.1.1 Verify all the relevant components having the updated airgap repository server CA certificate

Run this command to simply verify all the relevant components associating the TCA-CP.

```shell
[root@tcacp /home/admin/update-ca] ./update_ca.py verify-all -h

usage: update_ca.py verify-all [-h] --fqdn FQDN --cafile CAFILE

optional arguments:
  -h, --help       show this help message and exit

required arguments:
  --fqdn FQDN      FQDN of the airgap repository server
  --cafile CAFILE  new CA certificate file of the airgap repository server
```

For e.g

```shell
[root@tcacp /home/admin/update-ca]./update_ca.py verify-all --fqdn airgap-repo-server-2.ipv6.eng.vmware.com --cafile /home/admin/ca.crt
update_ca[INFO]: airgap repo: airgap-repo-server-2.ipv6.eng.vmware.com is valid
update_ca[INFO]: ########## verifying tkgcontexts ##########
update_ca[INFO]: tkgcontext[48fb570d-2226-4902-a893-3df2dbff97fd]: up to date
update_ca[INFO]: tkgcontext[5123887a-da9f-4312-8292-4d595c098a57]: up to date
update_ca[INFO]: ########## verifying management clusters ##########
update_ca[INFO]: # verifying management cluster[mc210], id[a1d9dcc8-d43f-4278-909e-0a22019a21db]
update_ca[INFO]: configmap kapp-controller-config/tkg-system: up to date
update_ca[INFO]: configmap tkr-controller-config/tkr-system: up to date
update_ca[INFO]: kubecontrolplane cr[mc210-master-control-plane/tkg-system]: up to date
update_ca[INFO]: kubeadmconfigtemplate cr[mc210-np1/tkg-system]: up to date
update_ca[INFO]: node[172.16.69.14]: up to date
update_ca[INFO]: node[172.16.68.231]: up to date
update_ca[INFO]: ########## verifying v1 workload clusters ##########
update_ca[INFO]: # verifying workload cluster[wc210v1], id[57a25f87-4718-4597-85f2-20926005de78]
update_ca[INFO]: configmap kapp-controller-config/tkg-system: up to date
update_ca[INFO]: kubecontrolplane cr[wc210v1-master-control-plane/wc210v1]: up to date
update_ca[INFO]: kubeadmconfigtemplate cr[wc210v1-np1/wc210v1]: up to date
update_ca[INFO]: query cluster wc210v1 node ips
update_ca[INFO]: node[172.16.68.224]: up to date
update_ca[INFO]: node[172.16.69.30]: up to date
update_ca[INFO]: ########## verifying minikube ##########
update_ca[INFO]: tcakubenetescluster cr[mc210/mc210]: up to date
update_ca[INFO]: ########## verifying v2 workload clusters ##########
update_ca[INFO]: # verifying v2 workload cluster[wc210v2]
update_ca[INFO]: tcakubenetescluster cr[wc210v2/wc210v2]: up to date
update_ca[INFO]: kubecontrolplane cr[wc210v2-cp-control-plane/wc210v2]: up to date
update_ca[INFO]: kubeadmconfigtemplate cr[wc210v2-np1/wc210v2]: up to date
update_ca[INFO]: configmap kapp-controller-config/tkg-system: up to date
update_ca[INFO]: node[172.16.70.103]: up to date
update_ca[INFO]: node[172.16.69.100]: up to date
update_ca[INFO]: node[172.16.68.86]: up to date
```

If all output logs are INFO and components are show "up to date", then the system is already with the right CA file.

If the output logs has ERROR/CRITICAL message, some components may show "out of date", it is required to update the components  with the new CA file with commands specified in section 1.1.2 or 1.2 - 1.5. Take following command and output for e.g

```shell
[root@tcacp /home/admin/update-ca]./update_ca.py verify-all --fqdn airgap-repo-server-2.ipv6.eng.vmware.com --cafile /home/admin/ca.crt
update_ca[INFO]: airgap repo: airgap-repo-server-2.ipv6.eng.vmware.com is valid
update_ca[INFO]: ########## verifying tkgcontexts ##########
update_ca[ERROR]: tkgcontext[5123887a-da9f-4312-8292-4d595c098a57]: out of date
update_ca[ERROR]: tkgcontext[48fb570d-2226-4902-a893-3df2dbff97fd]: out of date
update_ca[INFO]: ########## verifying management clusters ##########
update_ca[INFO]: # verifying management cluster[mc210], id[a1d9dcc8-d43f-4278-909e-0a22019a21db]
update_ca[ERROR]: configmap kapp-controller-config/tkg-system: out of date
update_ca[ERROR]: configmap tkr-controller-config/tkr-system: out of date
update_ca[ERROR]: kubecontrolplane cr[mc210-master-control-plane/tkg-system]: out of date
update_ca[ERROR]: kubeadmconfigtemplate cr[mc210-np1/tkg-system]: out of date
update_ca[ERROR]: node[172.16.69.14]: out of date, SSL certificate problem
update_ca[ERROR]: node[172.16.68.231]: out of date, SSL certificate problem
update_ca[INFO]: ########## verifying v1 workload clusters ##########
update_ca[INFO]: # verifying workload cluster[wc210v1], id[57a25f87-4718-4597-85f2-20926005de78]
update_ca[INFO]: configmap kapp-controller-config/tkg-system: up to date
update_ca[ERROR]: kubecontrolplane cr[wc210v1-master-control-plane/wc210v1]: out of date
update_ca[ERROR]: kubeadmconfigtemplate cr[wc210v1-np1/wc210v1]: out of date
update_ca[INFO]: query cluster wc210v1 node ips
update_ca[ERROR]: node[172.16.68.224]: out of date, SSL certificate problem
update_ca[ERROR]: node[172.16.69.30]: out of date, SSL certificate problem
update_ca[INFO]: ########## verifying minikube ##########
update_ca[ERROR]: tcakubenetescluster cr[mc210/mc210]: out of date
update_ca[INFO]: ########## verifying v2 workload clusters ##########
update_ca[INFO]: # verifying v2 workload cluster[wc210v2]
update_ca[ERROR]: tcakubenetescluster cr[wc210v2/wc210v2]: out of date
update_ca[ERROR]: kubecontrolplane cr[wc210v2-cp-control-plane/wc210v2]: out of date
update_ca[ERROR]: kubeadmconfigtemplate cr[wc210v2-np1/wc210v2]: out of date
update_ca[INFO]: configmap kapp-controller-config/tkg-system: up to date
update_ca[ERROR]: node[172.16.70.103]: out of date, SSL certificate problem
update_ca[ERROR]: node[172.16.69.100]: cannot communicate with airgap repo, return code:255, stdout: , stderr: ssh: connect to host 172.16.69.100 port 22: Connection timed out

update_ca[ERROR]: node[172.16.68.86]: out of date, SSL certificate problem
```



If you'd like to visit more info on the exact commands the script is executing to verify, try following commands with loglevel to debug

```shell
[root@tcacp /home/admin/update-ca]./update_ca.py --loglevel debug verify-all --fqdn airgap-repo-server-2.ipv6.eng.vmware.com --cafile /home/admin/ca.crt
```



### 1.1.2 Update all the relevant components with new CA certificate

Run this command to simply update all the relevant components associating the TCA-CP, which will cover the executions in section 1.2, 1.3, 1.4 and 1.5. If you run this command successfully, it is not required to run the following other commands.

```shell
[root@tcacp /home/admin/update-ca] ./update_ca.py update-all -h
usage: update_ca.py all [-h] --fqdn FQDN --cafile CAFILE --vcpass VCPASS

optional arguments:
  -h, --help       show this help message and exit

required arguments:
  --fqdn FQDN      FQDN of the airgap repository server
  --cafile CAFILE  new CA certificate file of the airgap repository server
  --vcpass VCPASS  vCenter Password
```

for e.g.

```shell
[root@tcacp /home/admin/update-ca] ./update_ca.py update-all --fqdn airgap-repo-server.example.com --cafile /home/admin/ca.crt --vcpass password
```



Note that during the updating, cluster control plane nodes will be redeployed that may lead to cluster temporary access issue, in case of single cluster control plane node. The script might fail in some step because of it. The script can be run again and again util no error reported.



## 1.2 Update KBS tkgcontexts

Run this command to update KBS tkgcontexts

```shell
[root@tcacp /home/admin/update-ca] ./update_ca.py tkgcontexts -h
usage: update_ca.py tkgcontexts [-h] --fqdn FQDN --cafile CAFILE --vcpass VCPASS

optional arguments:
  -h, --help       show this help message and exit

required arguments:
  --fqdn FQDN      FQDN of the airgap repository server
  --cafile CAFILE  new CA certificate file of the airgap repository server
  --vcpass VCPASS  vCenter Password
```

for e.g.

```shell
[root@tcacp /home/admin/update-ca] ./update_ca.py tkgcontexts --fqdn airgap-repo-server.example.com --cafile /home/admin/ca.crt --vcpass password
```

> Check the output messages on console for any errors/progress.

## 1.3 Update all Management Clusters

```shell
[root@tcacp /home/admin/update-ca] ./update_ca.py mgmtclusters -h
usage: update_ca.py mgmtclusters [-h] --fqdn FQDN --cafile CAFILE

optional arguments:
  -h, --help       show this help message and exit

required arguments:
  --fqdn FQDN      FQDN of the airgap repository server
  --cafile CAFILE  new CA certificate file of the airgap repository server
```

for e.g

```shell
[root@tcacp /home/admin/update-ca] ./update_ca.py mgmtclusters --fqdn airgap-repo-server.example.com --cafile  /home/admin/ca.crt
```

> After running this step successfully, you can operate the management clusters as usual, for e.g creating new workload clusters on the updated management clusters

## 1.4 Update all v1 Workload Clusters

```shell
[root@tcacp /home/admin/update-ca]./update_ca.py v1clusters -h
usage: update_ca.py v1clusters [-h] --fqdn FQDN --cafile CAFILE

optional arguments:
  -h, --help       show this help message and exit

required arguments:
  --fqdn FQDN      FQDN of the airgap repository server
  --cafile CAFILE  new CA certificate file of the airgap repository server
```

for e.g

```shell
[root@tcacp /home/admin/update-ca] ./update_ca.py v1clusters --fqdn airgap-repo-server.example.com --cafile  /home/admin/ca.crt
```

> After running this step successfully,  you can operate v1 workload clusters as usual, for e.g, add node pool, scale out an existing node pool, install new addons etc.

## 1.5 Update all v2 Workload Clusters

```shell
root@tcacp /home/admin/update-ca]./update_ca.py v2clusters -h
usage: update_ca.py v1clusters [-h] --fqdn FQDN --cafile CAFILE

optional arguments:
  -h, --help       show this help message and exit

required arguments:
  --fqdn FQDN      FQDN of the airgap repository server
  --cafile CAFILE  new CA certificate file of the airgap repository server
```

For e.g

```shell
[root@tcacp /home/admin/update-ca] ./update_ca.py v2clusters --fqdn airgap-repo-server.example.com --cafile  /home/admin/ca.crt
```

> After running this step successfully,  you can operate v2 workload clusters as usual, for e.g, add node pool, scale out an existing node pool, install new addons etc.

# 2. Manual Steps to update single cluster CA certificate

## 2.0 Preparations

some inputs are require ca certificate in base64, so we need to get the base64 encoded string for the CA certificate, with following commands

```shell
# base64 /home/admin/ca.crt -w 0
```



## 2.1 Update a management cluster

### 2.1.0 Get resources

#### 2.1.0.1 Find the management cluster id to update via ccli

for. e.g

```shell
# ccli list mc

+-------+------------------+------------------+--------------------------------------+--------------+----------+
| INDEX | NAME             | CONTEXT          | ID                                   | CONNECTIVITY | SELECTED |
+-------+------------------+------------------+--------------------------------------+--------------+----------+
| 0     | ipv4-airgap-mgmt | ipv4-airgap-mgmt | 97bad1f2-bbed-4019-b226-b211f50bb3f4 | true         |          |
| 1     | ipv4-mgmt        | ipv4-mgmt        | b8e55039-63f8-447c-93c3-b86bf26c8412 | true         |          |
+-------+------------------+------------------+--------------------------------------+--------------+----------+
# ccli go 0
```



In the following "ipv4-airgap-mgmt" cluster is used as an example, with id "97bad1f2-bbed-4019-b226-b211f50bb3f4"

#### 2.1.0.2 Locate management cluster kubeconfig file

it locates at "/opt/vmware/k8s-bootstrapper/<cluster id>/kubeconfig, and create an alias to shorten the following command line

```shell
# ls /opt/vmware/k8s-bootstrapper/97bad1f2-bbed-4019-b226-b211f50bb3f4/
kubeconfig
# alias mk="kubectl --kubeconfig /opt/vmware/k8s-bootstrapper/97bad1f2-bbed-4019-b226-b211f50bb3f4/kubeconfig"
```

### 2.1.1 Update tkgcontext of management cluster

#### 2.1.1.1 Get cluster tkgcontext id, in the output "tkgID" is the tkgcontext id to update

```shell
# ccli show spec
tkgID: 38561a18-3ea9-402f-9568-dca4889a6b11
id: 97bad1f2-bbed-4019-b226-b211f50bb3f4
clusterName: ipv4-airgap-mgmt
kubernetesVersion: v1.22.9+vmware.1
serviceCIDR: 100.64.0.0/13
clusterCIDR: 100.96.0.0/11
....
```

#### 2.1.1.2 Save , edit and update tkgcontext

```shell
# curl -X GET http://localhost:8888/api/v1/tkgcontext/38561a18-3ea9-402f-9568-dca4889a6b11 | python -m json.tool > tkgcontext.json
# vi tkgcontext.json # update vc password and caCert
{
    "id": "38561a18-3ea9-402f-9568-dca4889a6b11",
    "ipFamilies": "IPv4",
    "infrastructure": {
        "type": "vsphere",
        "version": "7.0.3"
    },
    "vsphere": {
        "password": "<my vc password>"
        ...
    },
    "airgap": {
        "fqdn": "airgap-repo-serve.example.com",
        "caCert": "<update it with new ca.crt base64 string"
        }
    }
}
# curl -X PUT http://localhost:8888/api/v1/tkgcontext/38561a18-3ea9-402f-9568-dca4889a6b11 -d "`cat tkgcontext.json`"
```

### 2.1.2 Update management cluster nodes

#### 2.1.2.1 get cluster node IPs

```shell
# ccli show status
status: Running
phase: PostConfig
nodes:
- ip: 172.16.69.112
  vmName: ipv4-airgap-mgmt-master-control-plane-qc6nx
  ...
- ip: 172.16.69.213
  vmName: ipv4-airgap-mgmt-np1-7648d7cd8f-79xvg
  ...
- ip: 172.16.70.143
  vmName: ipv4-airgap-mgmt-np1-7648d7cd8f-svmz9
  ...
```

#### 2.1.2.2  login node and update CA cert

for each node we need to login and update, here we take one node for example:

```shell
# ssh capv@172.16.69.112
capv@ipv4-airgap-mgmt-master-control-plane-qc6nx [ ~ ]$ sudo su
root [ /home/capv ]# vi ca.crt # copy the ca cert content to this file
root [ /home/capv ]# cp ca.crt /etc/ssl/certs/airgap-repo-server.example.com.pem # end with .pem is a must!
root [ /home/capv ]# rehash_ca_certificates.sh
root [ /home/capv ]# curl https://airgap-repo-server.example.com -v --head # test it works
root [ /home/capv ]# cp ca.crt /etc/containerd/airgap-repo-server.example.com.crt
root [ /home/capv ]# systemctl restart containerd
root [ /home/capv ]# systemctl status containerd
root [ /home/capv ]# crictl pull airgap-repo-server.example.com/registry/tkr-compatibility:v1 # test pulling from airgap repo
```


### 2.1.3 Update management cluster secrets

#### 2.1.3.1 update tkg-pkg-tkg-system-values secret if exist

Save tkgpackagevalues.yaml value of tkg-pkg-tkg-system-values secret to a file

```shell
# mk get secret -n tkg-system tkg-pkg-tkg-system-values -o jsonpath={.data."tkgpackagevalues\.yaml"} | base64 -d > tkgpkg.yaml
```

edit tkgpkg.yaml with new CA certificate in base64 format, and save it with ":wq"

```yaml
# vi tkgpkg.yaml
akoOperatorPackage: {}
clusterclassPackage: {}
configvalues:
  ...
  TKG_CUSTOM_IMAGE_REPOSITORY_CA_CERTIFICATE: <new CA cert in base64 format>
  ...
tkrSourceControllerPackage:
  tkrSourceControllerPackageValues:
    bomImagePath: a-11.dc1.vmw/registry/tkr-bom
    bomMetadataImagePath: a-11.dc1.vmw/registry/tkr-compatibility
    caCerts: <new CA cert in base64 format>
  ...
```

patch secret

```
# mk patch secret -n tkg-system tkg-pkg-tkg-system-values -p "{\"data\":{\"tkgpackagevalues.yaml\": \"`base64 tkgpkg.yaml -w 0`\"}}"
```

#### 2.1.3.2 update tkr-source-controller-values secret if exist

Save values.yaml value of tkr-source-controller-values secret to a file

```shell
# mk get secret -n tkg-system tkr-source-controller-values -o jsonpath={.data."values\.yaml"} | base64 -d > tkrsource.yaml
```

edit tkrsource.yaml with new CA certificate in base64 format, and save it with ":wq"

```yaml
# vi tkrsource.yaml
namespace: tkg-system
legacyNamespace: tkr-system
bomImagePath: a-11.dc1.vmw/registry/tkr-bom
...
caCerts: <new CA cert in base64 format>
...
```

patch secret

```
# mk patch secret -n tkg-system tkr-source-controller-values -p "{\"data\":{\"values.yaml\": \"`base64 tkrsource.yaml -w 0`\"}}"
```

#### 2.1.3.3 update tkr-vsphere-resolver-values secret if exist

Save values.yaml value of tkr-vsphere-resolver-values secret to a file

```shell
# mk get secret -n tkg-system tkr-vsphere-resolver-values -o jsonpath={.data."values\.yaml"} | base64 -d > tkrvsphere.yaml
```

edit tkrvsphere.yaml with new CA certificate in base64 format, and save it with ":wq"

```yaml
# vi tkrvsphere.yaml
namespace: tkg-system
legacyNamespace: tkr-system
bomImagePath: a-11.dc1.vmw/registry/tkr-bom
...
caCerts: <new CA cert in base64 format>
...
```

patch secret

```
# mk patch secret -n tkg-system tkr-vsphere-resolver-values -p "{\"data\":{\"values.yaml\": \"`base64 tkrvsphere.yaml -w 0`\"}}"
```

### 2.1.4 Update management cluster configmaps

#### 2.1.4.1 update tkr-controller-config

```shell
# mk edit cm tkr-controller-config -n tkr-system
# Please edit the object below. Lines beginning with a '#' will be ignored,
# and an empty file will abort the edit. If an error occurs while saving this file will be
# reopened with the relevant failures.
#
apiVersion: v1
data:
  caCerts: |
    -----BEGIN CERTIFICATE-----
    ...
    -----END CERTIFICATE-----
  imageRepository: airgap-repo-server.example.com/registry
...
```

copy the new ca certificate content and overwrite existing caCerts field

save it with ":wq"

then restart tkr-controller-manager

```shell
# mk rollout restart deployment -n tkr-system tkr-controller-manager
```



#### 2.1.4.2 update kapp-controller-config

```shell
# mk edit cm kapp-controller-config -n tkg-system
# Please edit the object below. Lines beginning with a '#' will be ignored,
# and an empty file will abort the edit. If an error occurs while saving this file will be
# reopened with the relevant failures.
#
apiVersion: v1
data:
  caCerts: |
    -----BEGIN CERTIFICATE-----
    ...
    -----END CERTIFICATE-----
  imageRepository: airgap-repo-server.example.com/registry
...
```

copy the new ca certificate content and overwrite existing caCerts field

save it with ":wq"

then restart kapp-controller-manager

```shell
# mk rollout restart deployment -n tkg-system kapp-controller
```

### 2.1.5 Update management cluster kubecontrolplane and kubeadmconfigtemplate CRs

#### 2.1.5.1 Update Management cluster kcp (kubecontrolplane) CR

```
# mk get kcp -n tkg-system
NAME                                    CLUSTER            INITIALIZED   API SERVER AVAILABLE   REPLICAS   READY   UPDATED   UNAVAILABLE   AGE   VERSION
ipv4-airgap-mgmt-master-control-plane   ipv4-airgap-mgmt   true          true                   1          1       1         0             11d   v1.22.9+vmware.1
# mk edit kcp -n tkg-system ipv4-airgap-mgmt-master-control-plane
...
    - content: <cert-base64-content>
      encoding: base64
      path: /etc/containerd/airgap-repo-server.example.crt
      permissions: "0444"
...
```

locate the airgap repo certificate file content, and update it with CA certificate base64 string.

save it with ":wq"

#### 2.1.5.2 Update management cluster kct (kubeadmconfigtemplate) CR

```
# mk get kubeadmconfigtemplate -n tkg-system
NAME                   AGE
ipv4-airgap-mgmt-np1   11d
# mk edit kubeadmconfigtemplate -n tkg-system ipv4-airgap-mgmt-np1
...
spec:
  template:
    spec:
      files:
      - content: <cert-base64-content>
        encoding: base64
        path: /etc/containerd/airgap-repo-server.example.com.crt
        permissions: "0444"
...
```

locate the airgap repo certificate file content, and update it with CA certificate base64 string.

save it with ":wq"

### 2.1.6 Update tcakubenetescluster CR in TCA CP minikube

```
# kubectl config get-contexts
CURRENT   NAME                                      CLUSTER            AUTHINFO                 NAMESPACE
          ipv4-airgap-mgmt-admin@ipv4-airgap-mgmt   ipv4-airgap-mgmt   ipv4-airgap-mgmt-admin
          ipv4-mgmt-admin@ipv4-mgmt                 ipv4-mgmt          ipv4-mgmt-admin
*         minikube                                  minikube           minikube                 default
# kubectl config use-context minikube # if star is not on minikube in the last command
# kubectl get tkc -A
NAMESPACE          NAME               AGE
ipv4-airgap-mgmt   ipv4-airgap-mgmt   11d
ipv4-mgmt          ipv4-mgmt          13d
# kubectl edit tkc -n ipv4-airgap-mgmt ipv4-airgap-mgmt
...
    telco.vmware.com/airgap-ca-cert: <cert-base64-content>
    telco.vmware.com/airgap-fqdn: airgap-repo-server.example.com
...
```

locate the airgap repo certificate annotation content, and update it with CA certificate base64 string.

save it with ":wq"

## 2.2 Update a v1 workload cluster

### 2.2.0 Get resources

#### 2.2.0.1 Find the workload cluster id to update via ccli

```shell
# ccli list wc
+-------+------------------+------------------+------------------------------------------+----------------------------+--------------+----------+---------------------+
| INDEX | NAME             | CONTEXT          | ID                                       | VCENTER ADDRESSES          | CONNECTIVITY | SELECTED | TYPE                |
+-------+------------------+------------------+------------------------------------------+----------------------------+--------------+----------+---------------------+
| 0     | ipv4-airgap-v1wc | ipv4-airgap-v1wc | 1fabca0a-ac69-406f-950a-92e7ddf7c4ae     | vc70u3.ipv6.eng.vmware.com | true         |          | KBS                 |
| 1     | ipv4-airgap-v2wc | ipv4-airgap-v2wc | aa9fbf86d970421cea233a00b3ea62bf64354f5c | vc70u3.ipv6.eng.vmware.com | true         |          | KubeClusterOperator |
+-------+------------------+------------------+------------------------------------------+----------------------------+--------------+----------+---------------------+
# ccli go 0
```

in the following example, we will update cluster "ipv4-airgap-v1wc" with id "1fabca0a-ac69-406f-950a-92e7ddf7c4ae"



#### 2.2.0.2 Locate workload cluster kubeconfig file

it locates at "/opt/vmware/k8s-bootstrapper/<cluster id>/kubeconfig, and create an alias to shorten the following command lines

```shell
# ls /opt/vmware/k8s-bootstrapper/1fabca0a-ac69-406f-950a-92e7ddf7c4ae/
kubeconfig
# alias wk="kubectl --kubeconfig /opt/vmware/k8s-bootstrapper/1fabca0a-ac69-406f-950a-92e7ddf7c4ae/kubeconfig"
```



#### 2.2.0.3 Locate workload cluster's management cluster kubeconfig file

```shell
# ccli show spec
tkgID: 189118fc-232c-4119-9ad6-5669b0a63654
id: 1fabca0a-ac69-406f-950a-92e7ddf7c4ae
tkgMgmtClusterId: 97bad1f2-bbed-4019-b226-b211f50bb3f4
...
# alias mk="kubectl --kubeconfig /opt/vmware/k8s-bootstrapper/97bad1f2-bbed-4019-b226-b211f50bb3f4/kubeconfig"
```



### 2.2.1 Update tkgcontext of v1 workload cluster

#### 2.2.1.1 Get cluster tkgcontext id, in the output "tkgID" is the tkgcontext id to update

```shell
# ccli show spec
tkgID: 189118fc-232c-4119-9ad6-5669b0a63654
id: 1fabca0a-ac69-406f-950a-92e7ddf7c4ae
tkgMgmtClusterId: 97bad1f2-bbed-4019-b226-b211f50bb3f4
tkgManagementNamespace: ipv4-airgap-v1wc
clusterName: ipv4-airgap-v1wc
clusterPassword: '***'
kubernetesVersion: v1.22.9+vmware.1
serviceCIDR: 100.64.0.0/13
clusterCIDR: 100.96.0.0/11
```

tkgID: 189118fc-232c-4119-9ad6-5669b0a63654 is the tkgcontext id to update

#### 2.2.1.2 Save , edit and update tkgcontext

This step is exactly the same with the ones in section 2.1.1.2, but a different tkgcontext id. Refer to section 2.1.1.2.

### 2.2.2 Update v1 workload cluster nodes

This steps are exactly the same with the ones in section 2.1.2.1 and 2.1.2.2. Refer to steps in section 2.1.2.

### 2.2.3 Update v1 workload cluster kapp controller

#### 2.2.3.1 Update kapp controller addon secret on management cluster

Save cluster kapp controller addon secret to a file

```shell
# mk get secret -n ipv4-airgap-v1wc ipv4-airgap-v1wc-kapp-controller-addon -o jsonpath={.data."values\.yaml"} | base64 -d > kapp.yaml
```

edit kapp.yaml with new CA certificate, and save it with ":wq"

```yaml
# vi kapp.yaml
#@data/values
#@overlay/match-child-defaults missing_ok=True
---
kappController:
  ...
  config:
    caCerts: |-
      -----BEGIN CERTIFICATE-----
      <update this content with new CA certificate content>
      -----END CERTIFICATE-----
```

patch secret

```
# mk patch secret -n ipv4-airgap-v1wc ipv4-airgap-v1wc-kapp-controller-addon -p "{\"data\":{\"values.yaml\": \"`base64 kapp.yaml -w 0`\"}}"
```

#### 2.2.3.2 Update kapp controller configmap on workload cluster

for workload cluster only kapp-controller-config is required to be updated, pls refer to step in section 2.1.3.2. The only difference is using alias "wk" instead of "mk"

### 2.2.4 Update v1 workload cluster kubecontrolplane and kubeadmconfigtemplate CRs on its management cluster

#### 2.2.4.1 Update v1 workload cluster kcp (kubecontrolplane) CR

```shell
# mk get kcp -n ipv4-airgap-v1wc
NAME                                    CLUSTER            INITIALIZED   API SERVER AVAILABLE   REPLICAS   READY   UPDATED   UNAVAILABLE   AGE   VERSION
ipv4-airgap-v1wc-master-control-plane   ipv4-airgap-v1wc   true          true                   1          1       1         0             11d   v1.22.9+vmware.1
# mk edit kcp -n ipv4-airgap-v1wc ipv4-airgap-v1wc-master-control-plane
...
    - content: <cert-base64-content>
      encoding: base64
      path: /etc/containerd/airgap-repo-server.example.crt
      permissions: "0444"
...
```

locate the airgap repo certificate file content, and update it with CA certificate base64 string.

save it with ":wq"

#### 2.1.4.2 Update v1 workload cluster kct (kubeadmconfigtemplate) CRs

```shell
# mk get kubeadmconfigtemplate -n ipv4-airgap-v1wc
NAME                   AGE
ipv4-airgap-v1wc-np1   11d
# mk edit kubeadmconfigtemplate -n ipv4-airgap-v1wc ipv4-airgap-v1wc-np1
...
spec:
  template:
    spec:
      files:
      - content: <cert-base64-content>
        encoding: base64
        path: /etc/containerd/airgap-repo-server.example.com.crt
        permissions: "0444"
...
```

locate the airgap repo certificate file content, and update it with CA certificate base64 string.

save it with ":wq"

> Note that, in this example there's only one node pool in the cluster. for multiple node pools, each node pool's kubeadmconfigtemplate must be updated one by one.

## 2.3 Update a v2 workload cluster

### 2.3.0 Get Resources

#### 2.3.0.1 Locate workload cluster's management cluster via ccli

```shell
# ccli list mc
If you intend to use kubectl or nodeconfig operations or nodeconfigcli or vmconfigcli directly outside of CCLI please set the following before you proceed
export KUBECONFIG=/opt/vmware/ccli/resources/kubeconfig-1197591
Please ignore if you have already set the KUBECONFIG env in your current session
+-------+------------------+------------------+--------------------------------------+--------------+----------+
| INDEX | NAME             | CONTEXT          | ID                                   | CONNECTIVITY | SELECTED |
+-------+------------------+------------------+--------------------------------------+--------------+----------+
| 0     | ipv4-mgmt        | ipv4-mgmt        | b8e55039-63f8-447c-93c3-b86bf26c8412 | true         |          |
| 1     | ipv4-airgap-mgmt | ipv4-airgap-mgmt | 97bad1f2-bbed-4019-b226-b211f50bb3f4 | true         | *        |
+-------+------------------+------------------+--------------------------------------+--------------+----------+
```

#### 2.3.0.2 Locate workload cluster's management cluster kubeconfig file

This step is same with section 2.1.0.2, refer to section 2.1.0.2 to create alias for management cluster kubectl

#### 2.3.0.2 Get workload cluster kubeconfig file

```shell
# ccli list wc

+-------+------------------+------------------+------------------------------------------+----------------------------+--------------+----------+---------------------+
| INDEX | NAME             | CONTEXT          | ID                                       | VCENTER ADDRESSES          | CONNECTIVITY | SELECTED | TYPE                |
+-------+------------------+------------------+------------------------------------------+----------------------------+--------------+----------+---------------------+
| 0     | ipv4-airgap-v1wc | ipv4-airgap-v1wc | 1fabca0a-ac69-406f-950a-92e7ddf7c4ae     | vc70u3.ipv6.eng.vmware.com | true         |          | KBS                 |
| 1     | ipv4-airgap-v2wc | ipv4-airgap-v2wc | aa9fbf86d970421cea233a00b3ea62bf64354f5c | vc70u3.ipv6.eng.vmware.com | true         |          | KubeClusterOperator |
+-------+------------------+------------------+------------------------------------------+----------------------------+--------------+----------+---------------------+
```

Assuming ipv4-airgap-v2wc is the workload cluster to update, get its kubeconfig file from management cluster

```shell
# mk get secret -n ipv4-airgap-v2wc ipv4-airgap-v2wc-kubeconfig -o jsonpath={.data.value} | base64 -d > wc.kc
# pwd
/home/admin
# alias wk="kubectl --kubeconfig /home/admin/wc.kc"
```

### 2.3.1 Update v2 workload cluster nodes

#### 2.3.1.1 Get node IPs of workload cluster

```shell
# wk get node -o wide
NAME                                       STATUS   ROLES                  AGE   VERSION            INTERNAL-IP     EXTERNAL-IP     OS-IMAGE                 KERNEL-VERSION   CONTAINER-RUNTIME
ipv4-airgap-v2wc-np1-77d5888f68-279hc      Ready    <none>                 10h   v1.22.9+vmware.1   172.16.70.38    172.16.70.38    VMware Photon OS/Linux   4.19.232-2.ph3   containerd://1.5.11
ipv4-airgap-v2wc-np1-77d5888f68-5ss46      Ready    <none>                 11d   v1.22.9+vmware.1   172.16.69.162   172.16.69.162   VMware Photon OS/Linux   4.19.232-2.ph3   containerd://1.5.11
ipv4-airgap-v2wc-np1-77d5888f68-qh86w      Ready    <none>                 11d   v1.22.9+vmware.1   172.16.69.122   172.16.69.122   VMware Photon OS/Linux   4.19.232-2.ph3   containerd://1.5.11
ipv4-airgpap-v2wc-cp-control-plane-2vvsn   Ready    control-plane,master   12h   v1.22.9+vmware.1   172.16.69.159   172.16.69.159   VMware Photon OS/Linux   4.19.232-2.ph3   containerd://1.5.11
```



#### 2.3.1.2 login node and update CA cert

This step is exactly the same with section 2.1.2.2, but the target node IPs are got via step 2.3.1.1, so refer to section 2.1.2.2.

### 2.3.2 Update v2 workload cluster kapp controller

This step is exactly the same with section 2.2.3.

### 2.3.3 Update v2 workload cluster tcakubenetescluster CR on its management cluster

#### 2.3.3.1 Get the CR to update

```shell
# mk get tkc -n ipv4-airgap-v2wc ipv4-airgap-v2wc
NAME               AGE
ipv4-airgap-v2wc   11d 
```

 Currently, it is not allowed to update airgap info for this CR. To update it, we need to diable the webhook of tca-cluster-operator on the management cluster, then restore it back after updating it.

#### 2.3.3.2 Disable tca-cluster-operator webhook

```shell
# mk get ValidatingWebhookConfiguration tca-kubecluster-operator-validating-webhook-configuration -o yaml > webhook.yaml
# mk delete ValidatingWebhookConfiguration tca-kubecluster-operator-validating-webhook-configuration
```



#### 2.3.3.3 Update tcakubeclusteroperator CR

```shell
# mk edit tkc -n ipv4-airgap-v2wc ipv4-airgap-v2wc
...
spec:
  airgap:
    caCert: <cert-base64-content>
    fqdn: airgap-repo-server.example.com
...
```

update spec.airgap.caCert with the new CA base64 content, and save with ":wq"

#### 2.3.3.4 Restore tca-cluster-operator webhook

```shell
# mk apply -f webhook.yaml
```

### 2.3.4 Update v2 workload cluster kubecontrolplane and kubeadmconfigtemplate CRs on its management cluster

This step is exactly the same with section 2.2.4.

# 3 Update TCA manager DB

## 3.1 TCA Mongo DB

### 3.1.1 Step 1: Prepare base64 string of the new CA certificate

```shell
# base64 <ca.crt> -w 0
```

### 3.1.2 Step 2: Login to TCA Manager Appliance via SSH

```shell
# ssh admin@<tca-m ip>
```

### 3.3.3 Step 3: Update postgres DB with the CA certificate base64 string

```shell
[admin@tcam ~]$ export PGPASSWORD=$(cat /common/pgsql/passwords/tca_admin)
[admin@tcam ~]$ psql -d tca -U tca_admin -h localhost
psql (14.2)
Type "help" for help.
tca=> select * from "Extension" where strpos(val::text,'<airgap server fqdn>')>0;
  id | val | creationDate | lastUpdated
  3 | {"name": "airgap-repo-server-2", "type": "Repository", "state": "ENABLED", "version": "", "isDeleted": false, "description": "", "extensionId": "d6618c6e-c40e-43f1-bb32-9e44b2a1fa25", "creationUser": "administrator@vsphere.local", "extensionKey": "", "interfaceInfo": {"fqdn": "airgap-repo-server-2.ipv6.eng.vmware.com", "caCert": "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"}, "lastUpdateUser": "administrator@vsphere.local", "extensionSubtype": "Airgap", "creationEnterprise": "HybridityAdmin", "additionalParameters": {}, "creationOrganization": "HybridityAdmin", "lastUpdateEnterprise": "HybridityAdmin", "lastUpdateOrganization": "HybridityAdmin"} | 2023-03-15 02:13:03.894 | 2023-03-15 06:09:50.291678
  (1 row)
tca=> update "Extension" set val='{"name": "airgap-repo-server-2", "type": "Repository", "state": "ENABLED", "version": "", "isDeleted": false, "description": "", "extensionId": "d6618c6e-c40e-43f1-bb32-9e44b2a1fa25", "creationUser": "administrator@vsphere.local", "extensionKey": "", "interfaceInfo": {"fqdn": "airgap-repo-server-2.ipv6.eng.vmware.com", "caCert": "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"}, "lastUpdateUser": "administrator@vsphere.local", "extensionSubtype": "Airgap", "creationEnterprise": "HybridityAdmin", "additionalParameters": {}, "creationOrganization": "HybridityAdmin", "lastUpdateEnterprise": "HybridityAdmin", "lastUpdateOrganization": "HybridityAdmin"}' where id = 3;
UPDATE 1
tca=> 

Get record id and json string with SQL select statement, copy the long json string of field Extension.val and replace the caCert with new base64 string of CA certificate(output of Step 1), then use SQL update statement to update the record with the <new one-line json string> and record id.

# 4 Troubleshooting/Known Issues

## 4.1 Scale out v2 workload cluster control plane fail

After updating cluster with the new CA certificate, operations of the clusters work except scale out workload cluster control plane. for example changing workload cluster control plane node replica number from 1 to 3, it reports below warning:

> HttpStatus: 422 : admission webhook "vtcakubernetescluster.kb.io" denied the request: TcaKubernetesCluster.telco.vmware.com "wc210v2" is invalid: spec.airgap: Invalid value: "airgap": cannot be modified

Apply step 2.3.3.2 can solve it and unblock scaling out, but on UI it will show "Processing" status even if scaling up succeeds.
