# Helm charts for fluent logging

This helm chart includes charts for Fluentd and Fluentbit.
Fluentd is configured to run as a deployment and fluentbit will
run as a daemonset. In this architecture Fluentbit is the log collector
and Fluentd is the log aggregator.

The default option is to forward all logs to a vRealize Log Insight endpoint.
This can be changed by changing the output of the copy plugin
in Fluentd values.

## To install this chart
`# helm install -n <namespace> <release name> fluent -f <your values.yaml>`

## Values to override
These are the key values to override when installing this chart

```yaml
fluentd:
  repository: tca-docker-local.artifactory.eng.vmware.com
  name: fluentd
  pullPolicy: Always
  tag: 2.0.0

  logInsight_host: x.x.x.x
  logInsight_port: xxxx

# Override fluent-bit values under the fluent-bit label
fluent-bit:
  repository: tca-docker-local.artifactory.eng.vmware.com
  name: fluent-bit
  pullPolicy: Always
  tag: 2.0.0

  # fluentd to forward logs to
  fluentd:
    host: fluentd
    namespace: logging
    logging_port: 24224
    monitoring_port: 24220
```