{{- define "image" -}}
{{- if and .Values.global.useCommonImageParams (or (not .Values.global.image.repository) (not .Values.global.image.tag)) }}
{{ fail "A valid global.image.repositoy and global.image.tag is required" }}
{{- end -}}
{{- if .Values.global.useCommonImageParams }}
image: {{ .Values.global.image.repository }}/{{ .Values.image.name}}:{{ .Values.global.image.tag }}
{{- else }}
image: {{ .Values.image.repository }}/{{ .Values.image.name}}:{{ .Values.image.tag }}
{{- end }}
imagePullPolicy: {{ .Values.image.pullPolicy }}
{{- end -}}

{{- define "ports" -}}
ports:
  {{- range .Values.service.ports }}
  - name: {{ .name }}
    protocol: {{ .protocol }}
    containerPort: {{ .port }}
  {{- end }}
{{- end -}}

{{- define "labels" -}}
app.kubernetes.io/name: {{ .Chart.Name }}
helm.sh/chart: {{ .Chart.Name }}-{{ .Chart.Version | replace "+" "_" }}
app.kubernetes.io/managed-by: {{ .Release.Service }}
app.kubernetes.io/instance: {{ .Release.Name }}
{{- end -}}

{{- define "tolerations" -}}
tolerations:
{{- toYaml .Values.tolerations | nindent 2}}
{{- end -}}