{{- define "fileConfigs" -}}
"01_sources.conf": |-
  <source>
    @type forward
    {{ if .Values.global.ipv6 -}}
    bind ::
    {{- else -}}
    bind 0.0.0.0
    {{- end }}
    port 24224
  </source>

  <source>
    @type monitor_agent
    {{ if .Values.global.ipv6 -}}
    bind ::
    {{- else -}}
    bind 0.0.0.0
    {{- end }}
    port 24220
  </source>

"02_filters.conf": |-
  # Prefix the tag by namespace. This would make it easy to match logs by namespaces
  <match kubernetes.**>
    @type rewrite_tag_filter
    <rule>
      key $.kubernetes.namespace_name
      pattern ^(.+)$
      tag $1.${tag}
    </rule>
  </match>

"04_outputs.conf": |-
  <match **>
    @type copy
    <store>
      @type vmware_loginsight
      @id out_vmw_li_all_container_logs
      scheme https
      ssl_verify false
      host "#{ENV['LOGINSIGHT_HOST']}"
      port "#{ENV['LOGINSIGHT_PORT']}"
      # Keys from log event whose values should be added as log message/text to
      # Loginsight. Note these key/value pairs  won't be added as metadata/fields
      log_text_keys ["log","msg","message"]
      # Use this flag if you want to enable http debug logs
      http_conn_debug false
    </store>
    # copy plugin supports sending/copying logs to multiple plugins
    #<store>
    #  @type stdout
    #</store>
  </match>
{{- end -}}
