# Gatekeeper Helm Chart

## Get Repo Info

```console
helm repo add gatekeeper https://open-policy-agent.github.io/gatekeeper/charts
helm repo update
```

_See [helm repo](https://helm.sh/docs/helm/helm_repo/) for command documentation._

## Install Chart

```console
# Helm install with gatekeeper-system namespace already created
$ helm install -n gatekeeper-system [RELEASE_NAME] gatekeeper/gatekeeper

# Helm install and create namespace
$ helm install -n gatekeeper-system [RELEASE_NAME] gatekeeper/gatekeeper --create-namespace

```

_See [parameters](#parameters) below._

_See [helm install](https://helm.sh/docs/helm/helm_install/) for command documentation._

## Upgrade Chart

**Upgrading from < v3.4.0**
Chart 3.4.0 deprecates support for Helm 2 and also removes the creation of the `gatekeeper-system` Namespace from within
the chart. This follows Helm 3 Best Practices.

Option 1:
A simple way to upgrade is to uninstall first and re-install with 3.4.0 or greater.

```console
$ helm uninstall gatekeeper
$ helm install -n gatekeeper-system [RELEASE_NAME] gatekeeper/gatekeeper --create-namespace

```

Option 2:
Run the `helm_migrate.sh` script before installing the 3.4.0 or greater chart. This will remove the Helm secret for the
original release, while keeping all of the resources. It then updates the annotations of the resources so that the new
chart can import and manage them.

```console
$ helm_migrate.sh
$ helm install -n gatekeeper-system gatekeeper gatekeeper/gatekeeper
```

**Upgrading from >= v3.4.0**

```console
$ helm upgrade -n gatekeeper-system [RELEASE_NAME] gatekeeper/gatekeeper
```

_See [helm 2 to 3](https://helm.sh/docs/topics/v2_v3_migration/) for Helm 2 migration documentation._

## Exempting Namespace

The Helm chart automatically sets the Gatekeeper flag `--exempt-namespace={{ .Release.Namespace }}` in order to exempt
the namespace where the chart is installed, and adds the `admission.gatekeeper.sh/ignore` label to the namespace during
a post-install hook.

_See [Exempting Namespaces](https://open-policy-agent.github.io/gatekeeper/website/docs/exempt-namespaces) for more
information._

## Parameters

| Parameter                                                  | Description                                                                                                                                                                                                                                                                                    | Default                                                                                                                                                               |
|:-----------------------------------------------------------|:-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:----------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| postInstall.labelNamespace.enabled                         | Add labels to the namespace during post install hooks                                                                                                                                                                                                                                          | `true`                                                                                                                                                                |
| postInstall.labelNamespace.extraNamespaces                 | The extra namespaces that need to have the label during post install hooks                                                                                                                                                                                                                     | `[]`                                                                                                                                                                  |
| postInstall.labelNamespace.extraAnnotations                | Extra annotations added to the post install Job                                                                                                                                                                                                                                                | `{}`                                                                                                                                                                  |
| postInstall.labelNamespace.image.repository                | Image with kubectl to label the namespace                                                                                                                                                                                                                                                      | `openpolicyagent/gatekeeper-crds`                                                                                                                                     |
| postInstall.labelNamespace.image.tag                       | Image tag                                                                                                                                                                                                                                                                                      | Current release version: `v3.15.1`                                                                                                                             |
| postInstall.labelNamespace.image.pullPolicy                | Image pullPolicy                                                                                                                                                                                                                                                                               | `IfNotPresent`                                                                                                                                                        |
| postInstall.labelNamespace.image.pullSecrets               | Image pullSecrets                                                                                                                                                                                                                                                                              | `[]`                                                                                                                                                                  |
| postInstall.labelNamespace.extraRules                      | Extra rules for the gatekeeper-update-namespace-label Role                                                                                                                                                                                                                                     | `[]`                                                                                                                                                                  |
| postInstall.labelNamespace.priorityClassName               | Priority class name for gatekeeper-update-namespace-label Job                                                                                                                                                                                                                                  | ``                                                                                                                                                                    |
| postInstall.probeWebhook.enabled                           | Probe webhook API post install. When enabled along with `postInstall.labelNamespace.enabled`, this probe will run as part of `postInstall.labelNamespace` Job as an initContainer                                                                                                              | `true`                                                                                                                                                                |
| postInstall.probeWebhook.image.repository                  | Image with curl to probe the webhook API                                                                                                                                                                                                                                                       | `curlimages/curl`                                                                                                                                                     |
| postInstall.probeWebhook.image.tag                         | Image tag                                                                                                                                                                                                                                                                                      | `7.83.1`                                                                                                                                                              |
| postInstall.probeWebhook.image.pullPolicy                  | Image pullPolicy                                                                                                                                                                                                                                                                               | `IfNotPresent`                                                                                                                                                        |
| postInstall.probeWebhook.image.pullSecrets                 | Image pullSecrets                                                                                                                                                                                                                                                                              | `[]`                                                                                                                                                                  |
| postInstall.probeWebhook.waitTimeout                       | Total time to wait for the webhook API to become available                                                                                                                                                                                                                                     | `60`                                                                                                                                                                  |
| postInstall.probeWebhook.httpTimeout                       | HTTP client timeout                                                                                                                                                                                                                                                                            | `2`                                                                                                                                                                   |
| postInstall.probeWebhook.insecureHTTPS                     | Ignore server SSL certificate                                                                                                                                                                                                                                                                  | `false`                                                                                                                                                               |
| postInstall.probeWebhook.priorityClassName                 | Priority class name for gatekeeper-probe-webhook-post-install Job                                                                                                                                                                                                                              | ``                                                                                                                                                                    |
| postInstall.affinity                                       | The affinity to use for pod scheduling in postInstall hook jobs                                                                                                                                                                                                                                | `{}`                                                                                                                                                                  |
| postInstall.tolerations                                    | The tolerations to use for pod scheduling in postInstall hook jobs                                                                                                                                                                                                                             | `[]`                                                                                                                                                                  |
| postInstall.nodeSelector                                   | The node selector to use for pod scheduling in postInstall hook jobs                                                                                                                                                                                                                           | `kubernetes.io/os: linux`                                                                                                                                             |
| postInstall.resources                                      | The resource request/limits for the container image in postInstall hook jobs                                                                                                                                                                                                                   | `{}`                                                                                                                                                                  |
| postInstall.securityContext                                | Security context applied on the container                                                                                                                                                                                                                                                      | `{ "allowPrivilegeEscalation": false, "capabilities": "drop": [all], "readOnlyRootFilesystem": true, "runAsGroup": 999, "runAsNonRoot": true, "runAsUser": 1000 }`    |
| postUpgrade.labelNamespace.enabled                         | Add labels to the namespace during post upgrade hooks                                                                                                                                                                                                                                          | `false`                                                                                                                                                               |
| postUpgrade.labelNamespace.extraNamespaces                 | The extra namespaces that need to have the label during post upgrade hooks                                                                                                                                                                                                                     | `[]`                                                                                                                                                                  |
| postUpgrade.labelNamespace.extraAnnotations                | Extra annotations added to the post upgrade Job                                                                                                                                                                                                                                                | `{}`                                                                                                                                                                  |
| postUpgrade.labelNamespace.image.repository                | Image with kubectl to label the namespace                                                                                                                                                                                                                                                      | `openpolicyagent/gatekeeper-crds`                                                                                                                                     |
| postUpgrade.labelNamespace.image.tag                       | Image tag                                                                                                                                                                                                                                                                                      | Current release version: `v3.15.1`                                                                                                                             |
| postUpgrade.labelNamespace.image.pullPolicy                | Image pullPolicy                                                                                                                                                                                                                                                                               | `IfNotPresent`                                                                                                                                                        |
| postUpgrade.labelNamespace.image.pullSecrets               | Image pullSecrets                                                                                                                                                                                                                                                                              | `[]`                                                                                                                                                                  |
| postUpgrade.labelNamespace.priorityClassName               | Priority class name for gatekeeper-update-namespace-label-post-upgrade Job                                                                                                                                                                                                                     | ``                                                                                                                                                                    |
| postUpgrade.affinity                                       | The affinity to use for pod scheduling in postUpgrade hook jobs                                                                                                                                                                                                                                | `{}`                                                                                                                                                                  |
| postUpgrade.tolerations                                    | The tolerations to use for pod scheduling in postUpgrade hook jobs                                                                                                                                                                                                                             | `[]`                                                                                                                                                                  |
| postUpgrade.nodeSelector                                   | The node selector to use for pod scheduling in postUpgrade hook jobs                                                                                                                                                                                                                           | `kubernetes.io/os: linux`                                                                                                                                             |
| postUpgrade.resources                                      | The resource request/limits for the container image in postUpgrade hook jobs                                                                                                                                                                                                                   | `{}`                                                                                                                                                                  |
| postUpgrade.securityContext                                | Security context applied on the container                                                                                                                                                                                                                                                      | `{ "allowPrivilegeEscalation": false, "capabilities": "drop": [all], "readOnlyRootFilesystem": true, "runAsGroup": 999, "runAsNonRoot": true, "runAsUser": 1000 }`    |
| preInstall.crdRepository.image.repository                  | Image with kubectl to update the CRDs. If not set, the `image.crdRepository` is used instead.                                                                                                                                                                                                  | `null`                                                                                                                                                                |
| preInstall.crdRepository.image.tag                         | Image tag                                                                                                                                                                                                                                                                                      | Current release version: `v3.15.1`                                                                                                                             |
| preUninstall.deleteWebhookConfigurations.enabled           | Delete webhooks before gatekeeper itself is uninstalled                                                                                                                                                                                                                                        | `false`                                                                                                                                                               |
| preUninstall.deleteWebhookConfigurations.image.repository  | Image with kubectl to delete the webhooks                                                                                                                                                                                                                                                      | `openpolicyagent/gatekeeper-crds`                                                                                                                                     |
| preUninstall.deleteWebhookConfigurations.image.tag         | Image tag                                                                                                                                                                                                                                                                                      | Current release version: `v3.15.1`                                                                                                                             |
| preUninstall.deleteWebhookConfigurations.image.pullPolicy  | Image pullPolicy                                                                                                                                                                                                                                                                               | `IfNotPresent`                                                                                                                                                        |
| preUninstall.deleteWebhookConfigurations.image.pullSecrets | Image pullSecrets                                                                                                                                                                                                                                                                              | `[]`                                                                                                                                                                  |
| preUninstall.deleteWebhookConfigurations.extraRules        | Extra rules for the gatekeeper-delete-webhook-configs Role                                                                                                                                                                                                                                     | `[]`                                                                                                                                                                  |
| preUninstall.deleteWebhookConfigurations.priorityClassName | Priority class name for gatekeeper-delete-webhook-configs Job                                                                                                                                                                                                                                  | ``                                                                                                                                                                    |
| preUninstall.affinity                                      | The affinity to use for pod scheduling in preUninstall hook jobs                                                                                                                                                                                                                               | `{}`                                                                                                                                                                  |
| preUninstall.tolerations                                   | The tolerations to use for pod scheduling in preUninstall hook jobs                                                                                                                                                                                                                            | `[]`                                                                                                                                                                  |
| preUninstall.nodeSelector                                  | The node selector to use for pod scheduling in preUninstall hook jobs                                                                                                                                                                                                                          | `kubernetes.io/os: linux`                                                                                                                                             |
| preUninstall.resources                                     | The resource request/limits for the container image in preUninstall hook jobs                                                                                                                                                                                                                  | `{}`                                                                                                                                                                  |
| preUninstall.securityContext                               | Security context applied on the container                                                                                                                                                                                                                                                      | `{ "allowPrivilegeEscalation": false, "capabilities": "drop": [all], "readOnlyRootFilesystem": true, "runAsGroup": 999, "runAsNonRoot": true, "runAsUser": 1000 }`    |
| psp.enabled                                                | Enabled PodSecurityPolicy                                                                                                                                                                                                                                                                      | `false`                                                                                                                                                                |
| upgradeCRDs.enabled                                        | Upgrade CRDs using pre-install/pre-upgrade hooks                                                                                                                                                                                                                                               | `true`                                                                                                                                                                |
| upgradeCRDs.extraRules                                     | Extra rules for the gatekeeper-admin-upgrade-crds ClusterRole                                                                                                                                                                                                                                  | `[]`                                                                                                                                                                  |
| upgradeCRDs.priorityClassName                              | Priority class name for gatekeeper-update-crds-hook Job                                                                                                                                                                                                                                        | ``                                                                                                                                                                    |
| crds.affinity                                              | The affinity to use for pod scheduling in crds hook jobs                                                                                                                                                                                                                                       | `{}`                                                                                                                                                                  |
| crds.tolerations                                           | The tolerations to use for pod scheduling in crds hook jobs                                                                                                                                                                                                                                    | `[]`                                                                                                                                                                  |
| crds.nodeSelector                                          | The node selector to use for pod scheduling in crds hook jobs                                                                                                                                                                                                                                  | `kubernetes.io/os: linux`                                                                                                                                             |
| crds.resources                                             | The resource request/limits for the container image in crds hook jobs                                                                                                                                                                                                                          | `{}`                                                                                                                                                                  |
| crds.securityContext                                       | Security context applied to the container                                                                                                                                                                                                                                                      | `{ "allowPrivilegeEscalation": false, "capabilities": "drop": [all], "readOnlyRootFilesystem": true, "runAsGroup": 65532, "runAsNonRoot": true, "runAsUser": 65532 }` |
| auditInterval                                              | The frequency with which audit is run                                                                                                                                                                                                                                                          | `60`                                                                                                                                                                  |
| constraintViolationsLimit                                  | The maximum # of audit violations reported on a constraint                                                                                                                                                                                                                                     | `20`                                                                                                                                                                  |
| auditFromCache                                             | Take the roster of resources to audit from the audit cache                                                                                                                                                                                                                                     | `false`                                                                                                                                                               |
| auditChunkSize                                             | Chunk size for listing cluster resources for audit (alpha feature)                                                                                                                                                                                                                             | `500`                                                                                                                                                                 |
| auditMatchKindOnly                                         | Only check resources of the kinds specified in all constraints defined in the cluster.                                                                                                                                                                                                         | `false`                                                                                                                                                               |
| disableValidatingWebhook                                   | Disable the validating webhook                                                                                                                                                                                                                                                                 | `false`                                                                                                                                                               |
| disableMutation                                            | Disable mutation                                                                                                                                                                                                                                                                               | `false`                                                                                                                                                               |
| validatingWebhookName                                      | The name of the `ValidatingWebhookConfiguration`                                                                                                                                                                                                                                               | `gatekeeper-validating-webhook-configuration`                                                                                                                         |
| validatingWebhookTimeoutSeconds                            | The timeout for the validating webhook in seconds                                                                                                                                                                                                                                              | `3`                                                                                                                                                                   |
| validatingWebhookFailurePolicy                             | The failurePolicy for the validating webhook                                                                                                                                                                                                                                                   | `Ignore`                                                                                                                                                              |
| validatingWebhookAnnotations                               | The annotations to add to the ValidatingWebhookConfiguration                                                                                                                                                                                                                                   | `{}`                                                                                                                                                                  |
| validatingWebhookObjectSelector                            | The label selector to further refine which namespaced resources will be selected by the webhook. Please note that an exemption label means users can circumvent Gatekeeper's validation webhook unless measures are taken to control how exemption labels can be set.                          | `{}`                                                                                                                                                                  |
| validatingWebhookCheckIgnoreFailurePolicy                  | The failurePolicy for the check-ignore-label validating webhook                                                                                                                                                                                                                                | `Fail`                                                                                                                                                                |
| validatingWebhookExemptNamespacesLabels                    | Additional namespace labels that will be exempt from the validating webhook. Please note that anyone in the cluster capable to manage namespaces will be able to skip all Gatekeeper validation by setting one of these labels for their namespace.                                            | `{}`                                                                                                                                                                  |
| validatingWebhookCustomRules                               | Custom rules for selecting which API resources trigger the webhook. Mutually exclusive with `enableDeleteOperations`. NOTE: If you change this, ensure all your constraints are still being enforced.                                                                                          | `{}`                                                                                                                                                                  |
| validatingWebhookURL                                       | Custom URL for Kubernetes API server to use to reach the validating webhook pod. If not set, the default of connecting via the kubernetes service endpoint is used.                                                                                                                            | `null`                                                                                                                                                                |
| enableDeleteOperations                                     | Enable validating webhook for delete operations. Does not work with `validatingWebhookCustomRules`                                                                                                                                                                                             | `false`                                                                                                                                                               |
| enableExternalData                                         | Enable external data                                                                                                                                                                                                                                                                           | `true`                                                                                                                                                                |
| enableGeneratorResourceExpansion                           | Enable generator resource expansion (beta feature)                                                                                                                                                                                                                                            | `true`                                                                                                                                                               |
| enableTLSHealthcheck                                       | Enable probing webhook API with certificate stored in certDir                                                                                                                                                                                                                                  | `false`                                                                                                                                                               |
| maxServingThreads                                          | Limit the number of concurrent calls the validation backend made by the validation webhook. -1 limits this value to GOMAXPROCS. Configuring this value may lower max RAM usage and limit CPU throttling, Tuning it can optimize serving capacity.                                              | `-1`                                                                                                                                                                  |
| metricsBackends                                            | Metrics exporters to use. Valid exporters are: `prometheus`, `stackdriver`, and `opentelemetry` starting from Gatekeeper 3.15                                                                                                                                                                                                  | `["prometheus"]`                                                                                                                                                      |
| mutatingWebhookName                                        | The name of the `MutatingWebhookConfiguration`                                                                                                                                                                                                                                                 | `gatekeeper-mutating-webhook-configuration`                                                                                                                           |
| mutatingWebhookFailurePolicy                               | The failurePolicy for the mutating webhook                                                                                                                                                                                                                                                     | `Ignore`                                                                                                                                                              |
| mutatingWebhookReinvocationPolicy                          | The reinvocationPolicy for the mutating webhook                                                                                                                                                                                                                                                | `Never`                                                                                                                                                               |
| mutatingWebhookAnnotations                                 | The annotations to add to the MutatingWebhookConfiguration                                                                                                                                                                                                                                     | `{}`                                                                                                                                                                  |
| mutatingWebhookExemptNamespacesLabels                      | Additional namespace labels that will be exempt from the mutating webhook. Please note that anyone in the cluster capable to manage namespaces will be able to skip all Gatekeeper validation by setting one of these labels for their namespace.                                              | `{}`                                                                                                                                                                  |
| mutatingWebhookObjectSelector                              | The label selector to further refine which namespaced resources will be selected by the webhook. Please note that an exemption label means users can circumvent Gatekeeper's mutation webhook unless measures are taken to control how exemption labels can be set.                            | `{}`                                                                                                                                                                  |
| mutatingWebhookTimeoutSeconds                              | The timeout for the mutating webhook in seconds                                                                                                                                                                                                                                                | `3`                                                                                                                                                                   |
| mutatingWebhookCustomRules                                 | Custom rules for selecting which API resources trigger the webhook. NOTE: If you change this, ensure all your constraints are still being enforced.                                                                                                                                            | `{}`                                                                                                                                                                  |
| mutatingWebhookURL                                         | Custom URL for Kubernetes API server to use to reach the mutating webhook pod. If not set, the default of connecting via the kubernetes service endpoint is used.                                                                                                                              | `null`                                                                                                                                                                |
| emitAdmissionEvents                                        | Emit K8s events in configurable namespace for admission violations (alpha feature)                                                                                                                                                                                                             | `false`                                                                                                                                                               |
| emitAuditEvents                                            | Emit K8s events in configurable namespace for audit violations (alpha feature)                                                                                                                                                                                                                 | `false`                                                                                                                                                               |
| auditEventsInvolvedNamespace                               | Emit audit events for each violation in the involved objects namespace, the default (false) generates events in the namespace Gatekeeper is installed in. Audit events from cluster-scoped resources will continue to generate events in the namespace that Gatekeeper is installed in         | `false`                                                                                                                                                               |
| admissionEventsInvolvedNamespace                           | Emit admission events for each violation in the involved objects namespace, the default (false) generates events in the namespace Gatekeeper is installed in. Admission events from cluster-scoped resources will continue to generate events in the namespace that Gatekeeper is installed in | `false`                                                                                                                                                               |
| logDenies                                                  | Log detailed info on each deny                                                                                                                                                                                                                                                                 | `false`                                                                                                                                                               |
| logLevel                                                   | Minimum log level                                                                                                                                                                                                                                                                              | `INFO`                                                                                                                                                                |
| image.pullPolicy                                           | The image pull policy                                                                                                                                                                                                                                                                          | `IfNotPresent`                                                                                                                                                        |
| image.repository                                           | Image repository                                                                                                                                                                                                                                                                               | `openpolicyagent/gatekeeper`                                                                                                                                          |
| image.release                                              | The image release tag to use                                                                                                                                                                                                                                                                   | Current release version: `v3.15.1`                                                                                                                             |
| image.pullSecrets                                          | Specify an array of imagePullSecrets                                                                                                                                                                                                                                                           | `[]`                                                                                                                                                                  |
| resources                                                  | The resource request/limits for the container image                                                                                                                                                                                                                                            | limits: 1 CPU, 512Mi, requests: 100mCPU, 256Mi                                                                                                                        |
| nodeSelector                                               | The node selector to use for pod scheduling                                                                                                                                                                                                                                                    | `kubernetes.io/os: linux`                                                                                                                                             |
| controllerManager.affinity                                 | The node affinity to use for controller manager pod scheduling                                                                                                                                                                                                                                 | `{}`                                                                                                                                                                  |
| controllerManager.topologySpreadConstraints                | The topology spread constraints to use for controller manager pod scheduling                                                                                                                                                                                                                   | `[]`                                                                                                                                                                  |
| controllerManager.tolerations                              | The tolerations to use for controller manager pod scheduling                                                                                                                                                                                                                                   | `[]`                                                                                                                                                                  |
| controllerManager.healthPort                               | Health port for controller manager                                                                                                                                                                                                                                                             | `9090`                                                                                                                                                                |
| controllerManager.port                                     | Webhook-server port for controller manager                                                                                                                                                                                                                                                     | `8443`                                                                                                                                                                |
| controllerManager.metricsPort                              | Metrics port for controller manager                                                                                                                                                                                                                                                            | `8888`                                                                                                                                                                |
| controllerManager.readinessTimeout                         | Timeout in seconds for the controller manager's readiness probe                                                                                                                                                                                                                                | `1`                                                                                                                                                                   |
| controllerManager.livenessTimeout                          | Timeout in seconds for the controller manager's liveness probe                                                                                                                                                                                                                                 | `1`                                                                                                                                                                   |
| controllerManager.logLevel                                 | The minimum log level for the controller manager, takes precedence over `logLevel` when specified                                                                                                                                                                                              | `null`                                                                                                                                                                |
| controllerManager.priorityClassName                        | Priority class name for controller manager                                                                                                                                                                                                                                                     | `system-cluster-critical`                                                                                                                                             |
| controllerManager.podSecurityContext                       | Security context on pod level for controller manager                                                                                                                                                                                                                                           | {fsGroup: 999, suplementalGroups: [999]}                                                                                                                              |
| controllerManager.exemptNamespaces                         | The exact namespaces to exempt by the admission webhook                                                                                                                                                                                                                                        | `[]`                                                                                                                                                                  |
| controllerManager.exemptNamespacePrefixes                  | The namespace prefixes to exempt by the admission webhook                                                                                                                                                                                                                                      | `[]`                                                                                                                                                                  |
| controllerManager.hostNetwork                              | Enables controllerManager to be deployed on hostNetwork                                                                                                                                                                                                                                        | `false`                                                                                                                                                               |
| controllerManager.dnsPolicy                                | Set the dnsPolicy for controllerManager pods                                                                                                                                                                                                                                                   | `ClusterFirst`                                                                                                                                                        |
| controllerManager.securityContext                          | Security context applied on the container                                                                                                                                                                                                                                                      | `{ "allowPrivilegeEscalation": false, "capabilities": "drop": [all], "readOnlyRootFilesystem": true, "runAsGroup": 999, "runAsNonRoot": true, "runAsUser": 1000 }`    |
| controllerManager.tlsMinVersion                            | Set the minimum supported TLS version for validating and mutating webhook servers                                                                                                                                                                                                              | `1.3`                                                                                                                                                                 |
| controllerManager.extraRules                               | Extra rules for the gatekeeper-manager-role Role                                                                                                                                                                                                                                               | `[]`                                                                                                                                                                  |
| controllerManager.networkPolicy.enabled                    | Should a network policy for the controller manager be created                                                                                                                                                                                                                                  | `false`                                                                                                                                                               |
| controllerManager.networkPolicy.ingress                    | Additional ingress rules to be added to the controller manager network policy                                                                                                                                                                                                                  | `{}`                                                                                                                                                                  |
| controllerManager.strategyType                             | The strategy type to use for Controller Manager deployment                                                                                                                                                                                                                                     | `RollingUpdate`                                                                                                                                                       |
| audit.affinity                                             | The node affinity to use for audit pod scheduling                                                                                                                                                                                                                                              | `{}`                                                                                                                                                                  |
| audit.topologySpreadConstraints                            | The topology spread constraints to use for audit pod scheduling                                                                                                                                                                                                                                | `[]`                                                                                                                                                                  |
| audit.tolerations                                          | The tolerations to use for audit pod scheduling                                                                                                                                                                                                                                                | `[]`                                                                                                                                                                  |
| audit.priorityClassName                                    | Priority class name for audit controller                                                                                                                                                                                                                                                       | `system-cluster-critical`                                                                                                                                             |
| audit.podSecurityContext                                   | Security context for audit on pod level                                                                                                                                                                                                                                                        | {fsGroup: 999, suplementalGroups: [999]}                                                                                                                              |
| audit.hostNetwork                                          | Enables audit to be deployed on hostNetwork                                                                                                                                                                                                                                                    | `false`                                                                                                                                                               |
| audit.dnsPolicy                                            | Set the dnsPolicy for audit pods                                                                                                                                                                                                                                                               | `ClusterFirst`                                                                                                                                                        |
| audit.securityContext                                      | Security context applied on the container                                                                                                                                                                                                                                                      | `{ "allowPrivilegeEscalation": false, "capabilities": "drop": [all], "readOnlyRootFilesystem": true, "runAsGroup": 999, "runAsNonRoot": true, "runAsUser": 1000 }`    |
| audit.healthPort                                           | Health port for audit                                                                                                                                                                                                                                                                          | `9090`                                                                                                                                                                |
| audit.metricsPort                                          | Metrics port for audit                                                                                                                                                                                                                                                                         | `8888`                                                                                                                                                                |
| audit.readinessTimeout                                     | Timeout in seconds for audit's readiness probe                                                                                                                                                                                                                                                 | `1`                                                                                                                                                                   |
| audit.livenessTimeout                                      | Timeout in seconds for the audit's liveness probe                                                                                                                                                                                                                                              | `1`                                                                                                                                                                   |
| audit.logLevel                                             | The minimum log level for audit, takes precedence over `logLevel` when specified                                                                                                                                                                                                               | `null`                                                                                                                                                                |
| replicas                                                   | The number of Gatekeeper replicas to deploy for the webhook                                                                                                                                                                                                                                    | `3`                                                                                                                                                                   |
| podAnnotations                                             | The annotations to add to the Gatekeeper pods                                                                                                                                                                                                                                                  | `container.seccomp.security.alpha.kubernetes.io/manager: runtime/default`                                                                                             |
| podLabels                                                  | The labels to add to the Gatekeeper pods                                                                                                                                                                                                                                                       | `{}`                                                                                                                                                                  |
| podCountLimit                                              | The maximum number of Gatekeeper pods to run                                                                                                                                                                                                                                                   | `100`                                                                                                                                                                 |
| secretAnnotations                                          | The annotations to add to the Gatekeeper secrets                                                                                                                                                                                                                                               | `{}`                                                                                                                                                                  |
| pdb.controllerManager.minAvailable                         | The number of controller manager pods that must still be available after an eviction                                                                                                                                                                                                           | `1`                                                                                                                                                                   |
| service.type                                               | Service type                                                                                                                                                                                                                                                                                   | `ClusterIP`                                                                                                                                                           |
| service.loadBalancerIP                                     | The IP address of LoadBalancer service                                                                                                                                                                                                                                                         | ``                                                                                                                                                                    |
| service.healthzPort                                        | Service port to gatekeeper Webhook health port                                                                                                                                                                                                                                                 | `9090`                                                                                                                                                                |
| rbac.create                                                | Enable the creation of RBAC resources                                                                                                                                                                                                                                                          | `true`                                                                                                                                                                |
| externalCertInjection.enabled                              | Enable the injection of an external certificate. This disables automatic certificate generation and rotation                                                                                                                                                                                   | `false`                                                                                                                                                               |
| externalCertInjection.secretName                           | Name of secret for injected certificate                                                                                                                                                                                                                                                        | `gatekeeper-webhook-server-cert`                                                                                                                                      |
| externaldataProviderResponseCacheTTL                           | TTL for the external data provider response cache. Specify the duration in 'h', 'm', or 's' for hours, minutes, or seconds respectively.                                                                                                                                                                                                                                                        | `3m`                                                                                                                                      |

## Contributing Changes

Please refer
to [Contributing to Helm Chart](https://open-policy-agent.github.io/gatekeeper/website/docs/help#contributing-to-helm-chart)
for modifying the Helm chart.
