# Wrapper Helm Chart for k8s-bootstrapper-operator

This directory contains helm charts having k8s-bootstrapper-operator as the subchart

Install this wrapper chart by running the following command.

```shell
$ helm dependency update ./kbs
$ helm upgrade -i -n <release_namespace> --create-namespace k8s-bootstrapper-operator ./kbs \
--set k8s-bootstrapper.image.repository=<image_repository> \
--set k8s-bootstrapper.image.controller=k8s-bootstrapper-operator \
--set k8s-bootstrapper.image.tag=<image_tag> \
--set k8s-bootstrapper.namespace=<release_namespace> \
--set k8s-bootstrapper.persistence.persistentVolumeClaim.rootFolder.storageClass=<storageClassName> --set k8s-bootstrapper.persistence.persistentVolumeClaim.Config.storageClass=<storageClassName> \
--set-file "kbs.bootstrapperCluster.sshPrivateKeyFile=<bootstrapper_ssh_private_key_file>" --set-file "kbs.bootstrapperCluster.sshPublicKeyFile=<bootstrapper_ssh_public_key_file>" \
--set kbs.isDevSetup=true --set kbs.managementCluster.clusterName=<management_cluster_name>
```

OR

```shell
$ helm dependency update ./kbs
$ helm upgrade -i -n <release_namespace> --create-namespace k8s-bootstrapper-operator ./kbs \
--set kbs.isDevSetup=false --set k8s-bootstrapper.image.repository=<image_repository> \
--set k8s-bootstrapper.image.controller=k8s-bootstrapper-operator \
--set k8s-bootstrapper.image.tag=<image_tag> \
--set k8s-bootstrapper.namespace=<release_namespace> \
--set k8s-bootstrapper.persistence.persistentVolumeClaim.rootFolder.storageClass=<storageClassName> --set k8s-bootstrapper.persistence.persistentVolumeClaim.Config.storageClass=<storageClassName> \
--set "kbs.bootstrapperCluster.sshPrivateKey=<bootstrapper_ssh_private_key>" --set "kbs.bootstrapperCluster.sshPublicKey=<bootstrapper_ssh_public_key>" \
--set kbs.managementCluster.clusterName=<management_cluster_name>
```

**Note**:
* `release_namespace` is tca control plane namespace which is `tca-system` in common.
* `storageClassName` is `vsphere-sc` for tkg clusters, leave it `""` (empty string) for docker desktop / minikube etc

OR (Recommended)

Use handy installation script present in `./kbs/kbs-install.sh`
```shell
export RELEASE_NAMESPACE="tca-system"
export MGMT_CLUSTER_NAME="<management_cluster_name>"
export BS_CLUSTER_SSH_PRIVATE_KEY="<path/to/bootstrapper_cluster_ssh_private_key_file>"
export BS_CLUSTER_SSH_PUBLIC_KEY="<path/to/bootstrapper_cluster_ssh_public_key_file>"

/bin/bash -x ./kbs/kbs-install.sh
```
Check the kbs pod by running
```shell
$ kubectl get pods -l "app=k8s-bootstrapper" -n <release_namespace>
NAME                              READY   STATUS    RESTARTS   AGE
k8s-bootstrapper-9b6cccc4-p95dc   1/1     Running   0          22h
```
Check configmaps and secrets successfully created
```shell
$ kubectl get secrets -l "app.kubernetes.io/name=kbs" -n <release_namespace>
NAME                        TYPE     DATA   AGE
config-secret               Opaque   1      49m
ssh-secret                  Opaque   2      49m

$ kubectl get cm -l "app.kubernetes.io/name=kbs" -n <release_namespace>
NAME            DATA   AGE
kbs-configmap   3      49m
```