# Helm Charts for MetalLB

[MetalLB](https://metallb.universe.tf/faq/) is an open source, rock solid LoadBalancer. It handles the `ServiceType: Loadbalancer`.

This chart bootstraps a MetalLB Controller Deployment and a MetalLB Speaker Daemonset on a Kubernetes cluster using the Helm package manager.

MetalLB advertises IP addresses in either layer2 mode (default) or BGP mode, configured by "config.address". An IP address range is required for MetalLB to allocate, along with settings for how to advertise those addresses if it's over BGP once assigned.
IP address range is either an explicit start-end range of IPs or a CIDR prefix, for example: 10.0.1.1-10.0.1.8, 10.0.1.0/27, or 10.0.1.8/32 for a single IP.

To deploy in layer2 mode, run
```shell
$ helm install metallb ./metallb --set config.addresses=$IP_RANGE
```
