{{/*
Generate metallb-config config map if it doesn't exist
*/}}
{{- define "gen.metallb-config" -}}
{{- $cm := lookup "v1" "ConfigMap" .Release.Namespace "metallb-config" -}}
{{- if $cm -}}
{{/*
   Reusing existing config map data
*/}}
config:
  {{ index $cm.data "config" | toYaml }}
{{- else -}}
{{/*
    Generate new data
*/}}
config: |
  address-pools:
    {{- $addressPools := split "," $.Values.config.addressPool -}}
    {{- $addresses := split "," $.Values.config.addresses -}}
    {{- range $i, $e := $addressPools }}
    - name: {{ $e }}
      protocol: {{ $.Values.config.protocol }}
      addresses:
      - {{ index $addresses $i }}
      {{- if eq $.Values.config.protocol "bgp" }}
      bgp-advertisements:
      - aggregation-length: {{ $.Values.config.bgp.aggregationLength }}
      {{- end }}
    {{- end }}
  {{- if eq $.Values.config.protocol "bgp" }}
  peers:
  - peer-address: {{ .Values.config.bgp.peerAddress }}
    peer-asn: {{ .Values.config.bgp.peerAsn }}
    my-asn: {{ .Values.config.bgp.myAsn }}
  {{- end -}}
{{- end -}}
{{- end -}}