{{/*
Expand the name of the chart.
*/}}
{{- define "network-slicing.name" -}}
{{- default .Chart.Name .Values.nameOverride | trunc 63 | trimSuffix "-" }}
{{- end }}

{{- define "network-slicing.image" -}}
{{- $registryName := .Values.image.repository -}}
{{- $imageName := .Values.image.name -}}
{{- $tag := .Values.image.tag -}}
{{- if or (.Values.useCommonImageParams) (not .Values.image.localImage) }}
{{- printf "%s/%s:%s" $registryName $imageName $tag | quote -}}
{{- else }}
{{- printf "%s" .Values.image.localImage | quote -}}
{{- end -}}
{{- end -}}

{{- define "network-slicing.dbMigrateImage" -}}
{{- $registryName := .Values.image.repository -}}
{{- $imageName := .Values.image.dbMigration -}}
{{- $tag := .Values.image.tag -}}
{{- $dbMigrationTag := .Values.image.dbMigrationTag -}}
{{- if or (.Values.useCommonImageParams) }}
{{- printf "%s/%s:%s" $registryName $imageName $tag | quote -}}
{{- else if .Values.image.dbMigrationLocalImage }}
{{- printf "%s" .Values.image.dbMigrationLocalImage | quote -}}
{{- else }}
{{- printf "%s/%s:%s" $registryName $imageName $dbMigrationTag | quote -}}
{{- end -}}
{{- end -}}

{{- define "network-slicing.imagePullPolicy" -}}
{{- if .Values.image.localImage }}
{{- print "Never" }}
{{- else }}
{{- printf "%s" .Values.image.pullPolicy -}}
{{- end -}}
{{- end -}}

{{/*
Create a default fully qualified app name.
We truncate at 63 chars because some Kubernetes name fields are limited to this (by the DNS naming spec).
If release name contains chart name it will be used as a full name.
*/}}
{{- define "network-slicing.fullname" -}}
{{- if .Values.fullnameOverride }}
{{- .Values.fullnameOverride | trunc 63 | trimSuffix "-" }}
{{- else }}
{{- $name := default .Chart.Name .Values.nameOverride }}
{{- if contains $name .Release.Name }}
{{- .Release.Name | trunc 63 | trimSuffix "-" }}
{{- else }}
{{- printf "%s-%s" .Release.Name $name | trunc 63 | trimSuffix "-" }}
{{- end }}
{{- end }}
{{- end }}

{{/*
Create chart name and version as used by the chart label.
*/}}
{{- define "network-slicing.chart" -}}
{{- printf "%s-%s" .Chart.Name .Chart.Version | replace "+" "_" | trunc 63 | trimSuffix "-" }}
{{- end }}

{{/*
Common labels
*/}}
{{- define "network-slicing.labels" -}}
helm.sh/chart: {{ include "network-slicing.chart" . }}
{{ include "network-slicing.selectorLabels" . }}
{{- if .Chart.AppVersion }}
app.kubernetes.io/version: {{ .Chart.AppVersion | quote }}
{{- end }}
app.kubernetes.io/managed-by: {{ .Release.Service }}
{{- end }}

{{/*
Selector labels
*/}}
{{- define "network-slicing.selectorLabels" -}}
app.kubernetes.io/name: {{ include "network-slicing.name" . }}
app.kubernetes.io/instance: {{ .Release.Name }}
{{- end }}

{{/*
Create the name of the service account to use
*/}}
{{- define "network-slicing.serviceAccountName" -}}
{{- if .Values.serviceAccount.create }}
{{- default (include "network-slicing.fullname" .) .Values.serviceAccount.name }}
{{- else }}
{{- default "default" .Values.serviceAccount.name }}
{{- end }}
{{- end }}
