#!/bin/bash

set -e

echo "Updating template1.."
PGPASSWORD=$PGPASSWORD psql -U $PGUSER -h $POSTGRESQL_FQDN template1 -f - << EOT

REVOKE ALL ON DATABASE template1 FROM public;
REVOKE ALL ON SCHEMA public FROM public;
GRANT ALL ON SCHEMA public TO $PGUSER;

EOT

# create the user if not exist, otherwise, update the user's password
if [ "$( PGPASSWORD=$PGPASSWORD psql -U $PGUSER -h $POSTGRESQL_FQDN -tAc "SELECT 1 FROM pg_user WHERE usename='$USERNAME'" )" != '1' ]
then
    echo "Creating user $USERNAME.."
    PGPASSWORD=$PGPASSWORD psql -U $PGUSER -h $POSTGRESQL_FQDN -f - <<EOT

    CREATE ROLE $USERNAME NOSUPERUSER NOCREATEDB NOCREATEROLE NOINHERIT LOGIN ENCRYPTED PASSWORD '$PASSWORD';

EOT
else
    echo "User $USERNAME already exists, update password.."
    PGPASSWORD=$PGPASSWORD psql -U $PGUSER -h $POSTGRESQL_FQDN -f - <<EOT

    ALTER ROLE $USERNAME WITH PASSWORD '$PASSWORD';
EOT
fi

# create databases if not exist and grant permissions
databases=(${DATABASES//,/ })
for database in "${databases[@]}"
do
    if [ "$( PGPASSWORD=$PGPASSWORD psql -U $PGUSER -h $POSTGRESQL_FQDN -tAc "SELECT 1 FROM pg_database WHERE datname='$database'" )" = '1' ]
    then
        echo "Database $database already exists, skip creation.."
        continue
    fi
    echo "Creating database $database.."
    PGPASSWORD=$PGPASSWORD psql -U $PGUSER -h $POSTGRESQL_FQDN template1 -f - <<EOT

    CREATE ROLE $database NOSUPERUSER NOCREATEDB NOCREATEROLE NOINHERIT NOLOGIN;
    GRANT $database TO $USERNAME;
    CREATE DATABASE $database WITH OWNER=$USERNAME;
    REVOKE ALL ON DATABASE $database FROM public;

EOT
    sleep 2
    PGPASSWORD=$PGPASSWORD psql -U $PGUSER -h $POSTGRESQL_FQDN $database -f - <<EOT

    GRANT ALL ON SCHEMA public TO $USERNAME WITH GRANT OPTION;

EOT
done
