#!/usr/bin/env bash

## set -x; # Do not enable this

tries=90
sleep_time=5
connection_string="postgresql://${PGUSER}:${PGPASSWORD}@${POSTGRESQL_FQDN}/${PGDATABASE}"

until psql "$connection_string" -c 'select version()' > /dev/null 2>&1 ; do
  echo "waiting for connection to succeed..."

  if [ $tries -le 0 ]; then
    echo "failed waiting for connection to succeed... after $(( tries*sleep_time )) seconds"
    exit 1
  fi

  tries=$((tries-1))
  sleep ${sleep_time}
done

echo "postgres cluster started..."