{{/* vim: set filetype=mustache: */}}
{{/*
Expand the name of the chart.
*/}}
{{- define "helm-chart.name" -}}
{{- default .Chart.Name .Values.nameOverride | trunc 63 | trimSuffix "-" }}
{{- end }}

{{/*
Create a default fully qualified app name.
We truncate at 63 chars because some Kubernetes name fields are limited to this (by the DNS naming spec).
If release name contains chart name it will be used as a full name.
*/}}
{{- define "helm-chart.fullname" -}}
{{- if .Values.fullnameOverride }}
{{- .Values.fullnameOverride | trunc 63 | trimSuffix "-" }}
{{- else }}
{{- $name := default .Chart.Name .Values.nameOverride }}
{{- if contains $name .Release.Name }}
{{- .Release.Name | trunc 63 | trimSuffix "-" }}
{{- else }}
{{- printf "%s-%s" .Release.Name $name | trunc 63 | trimSuffix "-" }}
{{- end }}
{{- end }}
{{- end }}

{{/*
Create chart name and version as used by the chart label.
*/}}
{{- define "helm-chart.chart" -}}
{{- printf "%s-%s" .Chart.Name .Chart.Version | replace "+" "_" | trunc 63 | trimSuffix "-" }}
{{- end }}

{{/*
Common labels
*/}}
{{- define "helm-chart.labels" -}}
helm.sh/chart: {{ include "helm-chart.chart" . }}
{{ include "helm-chart.selectorLabels" . }}
{{- if .Chart.AppVersion }}
app.kubernetes.io/version: {{ .Chart.AppVersion | quote }}
{{- end }}
app.kubernetes.io/managed-by: {{ .Release.Service }}
{{- end }}

{{/*
Selector labels
*/}}
{{- define "helm-chart.selectorLabels" -}}
app.kubernetes.io/name: {{ include "helm-chart.name" . }}
app.kubernetes.io/instance: {{ .Release.Name }}
{{- end }}

{{/*
Create the name of the service account to use
*/}}
{{- define "helm-chart.serviceAccountName" -}}
{{- if .Values.serviceAccount.create }}
{{- default (include "helm-chart.fullname" .) .Values.serviceAccount.name }}
{{- else }}
{{- default "default" .Values.serviceAccount.name }}
{{- end }}
{{- end }}

{{/*
Create resource change monitor service name
*/}}
{{- define "resource-change-monitor.service.name" -}}
{{ include "helm-chart.fullname" . }}-resource-change-monitor
{{- end }}

{/*
platform manager service name
*/}}
{{- define "platform-manager.service.name" -}}
{{ include "helm-chart.fullname" . }}-platform-manager
{{- end }}

{/*
helm-service service name
*/}}
{{- define "helm-service.service.name" -}}
{{ include "helm-chart.fullname" . }}-helm-service
{{- end }}

{{/*
Generate certificates
*/}}
{{- define "helm-chart.gen-certs" -}}
{{- $ca := genCA "ingress-ca" 365 -}}
{{- $host := default "tca.local" .Values.ingress.host }}
{{- $cert := genSignedCert $host nil (list $host) 365 $ca -}}
tls.crt: {{ $cert.Cert | b64enc }}
tls.key: {{ $cert.Key | b64enc }}
{{- end -}}

{{/*
Default TLS secret name
*/}}
{{- define "helm-chart.default-tls-secret-name" -}}
ingress-tls-secret
{{- end }}

{{/*
Create the ingress TLS secret name
*/}}
{{- define "helm-chart.ingress-tls-secret-name" -}}
{{ .Values.ingress.tls.secretName | default (include "helm-chart.default-tls-secret-name" .) }}
{{- end }}
