#!/bin/bash
# script to delete oldest hprof/heapdump if there is no space to create new hprof

heap_dumps_dir=${HEAP_DUMP_STORAGE:-"/opt/vmware/heap-dumps"}
available_disk_in_kb=$((`stat -f -c '%f*%S' ${heap_dumps_dir}`))
# minimum free disk is equal to the memory limit
min_free_disk_in_kb=$(cat /sys/fs/cgroup/memory/memory.limit_in_bytes)
if [ "${available_disk_in_kb}" -lt "${min_free_disk_in_kb}" ]; then
   ls -lt ${heap_dumps_dir}/* | tail -1 |sed -e 's/^.* //'|xargs -r rm -f
fi